/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.AnnotationSeverity;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrAssociation;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrElement;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.criteria.AntlrCriteria;
import cool.klass.model.converter.compiler.state.property.AntlrAssociationEnd;
import cool.klass.model.meta.grammar.KlassParser;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.tuple.Pair;

public class AntlrRelationship
extends AntlrElement {
    private static final Converter<String, String> LOWER_CAMEL_TO_UPPER_CAMEL = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
    private static final Converter<String, String> UPPER_TO_LOWER_CAMEL = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);
    private final AntlrAssociation association;
    private AntlrCriteria criteria;

    public AntlrRelationship(@Nonnull KlassParser.RelationshipContext elementContext, @Nonnull Optional<CompilationUnit> compilationUnit, AntlrAssociation association) {
        super((ParserRuleContext)elementContext, compilationUnit);
        this.association = Objects.requireNonNull(association);
    }

    @Nonnull
    public KlassParser.RelationshipContext getElementContext() {
        return (KlassParser.RelationshipContext)super.getElementContext();
    }

    public void setCriteria(AntlrCriteria criteria) {
        if (this.criteria != null) {
            throw new IllegalStateException();
        }
        this.criteria = Objects.requireNonNull(criteria);
    }

    public AntlrCriteria getCriteria() {
        return this.criteria;
    }

    @Override
    @Nonnull
    public Optional<IAntlrElement> getSurroundingElement() {
        return Optional.ofNullable(this.association);
    }

    @Override
    public boolean isContext() {
        return true;
    }

    @Override
    public Pair<Token, Token> getContextBefore() {
        return this.getEntireContext();
    }

    public void reportErrors(CompilerAnnotationHolder compilerAnnotationHolder) {
        AntlrAssociationEnd sourceEnd = this.association.getSourceEnd();
        AntlrAssociationEnd targetEnd = this.association.getTargetEnd();
        if (targetEnd.isToOne() && sourceEnd.isToMany() || sourceEnd.isToOne() && sourceEnd.isOwned()) {
            this.reportInferredEnd(compilerAnnotationHolder, sourceEnd, AntlrRelationship::getSourceInferredRelationshipText);
        } else if (sourceEnd.isToOne() && targetEnd.isToMany() || targetEnd.isToOne() && targetEnd.isOwned()) {
            this.reportInferredEnd(compilerAnnotationHolder, targetEnd, AntlrRelationship::getTargetInferredRelationshipText);
        } else if (sourceEnd.isToOne() && targetEnd.isToOneRequired()) {
            this.reportInferredEnd(compilerAnnotationHolder, sourceEnd, AntlrRelationship::getSourceInferredRelationshipText);
        } else if (targetEnd.isToOne() && sourceEnd.isToOneRequired()) {
            this.reportInferredEnd(compilerAnnotationHolder, targetEnd, AntlrRelationship::getTargetInferredRelationshipText);
        }
        this.criteria.reportErrors(compilerAnnotationHolder);
    }

    private void reportInferredEnd(CompilerAnnotationHolder compilerAnnotationHolder, AntlrAssociationEnd associationEnd, java.util.function.Function<AntlrAssociationEnd, String> sourceCodeTextFunction) {
        if (this.compilationUnit.flatMap(CompilationUnit::getMacroElement).isPresent()) {
            return;
        }
        KlassParser.CriteriaExpressionContext criteriaExpressionContext = this.getElementContext().criteriaExpression();
        String sourceText = AntlrElement.getSourceText((ParserRuleContext)criteriaExpressionContext);
        String sourceWithoutSpaceText = sourceText.replaceAll("\\s+", "");
        String sourceCodeText = sourceCodeTextFunction.apply(associationEnd);
        if (sourceCodeText.equals(sourceWithoutSpaceText)) {
            compilerAnnotationHolder.add("ERR_REL_INF", "Relationship in association '%s' is inferred and can be removed.".formatted(this.association.getName()), (IAntlrElement)this.criteria, (ParserRuleContext)criteriaExpressionContext, AnnotationSeverity.WARNING);
        }
    }

    private static String getSourceInferredRelationshipText(AntlrAssociationEnd associationEnd) {
        AntlrClass oppositeType = associationEnd.getOpposite().getType();
        return oppositeType.getAllKeyProperties().collect((Function & Serializable)each -> "this.%s%s==%s.%s".formatted(UPPER_TO_LOWER_CAMEL.convert((Object)oppositeType.getName()), LOWER_CAMEL_TO_UPPER_CAMEL.convert((Object)each.getName()), oppositeType.getName(), each.getName())).makeString("&&");
    }

    private static String getTargetInferredRelationshipText(AntlrAssociationEnd associationEnd) {
        AntlrClass oppositeType = associationEnd.getOpposite().getType();
        return oppositeType.getAllKeyProperties().collect((Function & Serializable)each -> "this.%s==%s.%s%s".formatted(each.getName(), associationEnd.getType().getName(), UPPER_TO_LOWER_CAMEL.convert((Object)oppositeType.getName()), LOWER_CAMEL_TO_UPPER_CAMEL.convert((Object)each.getName()))).makeString("&&");
    }
}

