/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state.property;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.AnnotationSeverity;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.AntlrElement;
import cool.klass.model.converter.compiler.state.AntlrIdentifierElement;
import cool.klass.model.converter.compiler.state.AntlrType;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.meta.domain.property.AbstractProperty;
import cool.klass.model.meta.grammar.KlassParser;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.factory.list.MutableListFactory;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;

public abstract class AntlrProperty
extends AntlrIdentifierElement {
    @Nonnull
    private final MutableList<AntlrModifier> modifiers = Lists.mutable.empty();
    private final MutableOrderedMap<String, MutableList<AntlrModifier>> modifiersByName = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<ParserRuleContext, AntlrModifier> modifiersByContext = OrderedMapAdapter.adapt(new LinkedHashMap());

    protected AntlrProperty(@Nonnull ParserRuleContext elementContext, @Nonnull Optional<CompilationUnit> compilationUnit, int ordinal, @Nonnull KlassParser.IdentifierContext nameContext) {
        super(elementContext, compilationUnit, ordinal, nameContext);
    }

    @Override
    public Pair<Token, Token> getContextBefore() {
        return this.getEntireContext();
    }

    @Nonnull
    public abstract AntlrType getType();

    @Nonnull
    public abstract AbstractProperty.PropertyBuilder<?, ?, ?> build();

    @Nonnull
    public abstract AbstractProperty.PropertyBuilder<?, ?, ?> getElementBuilder();

    @Nonnull
    public abstract AntlrClassifier getOwningClassifier();

    public boolean isVersion() {
        return this.getModifiers().anySatisfy(AntlrModifier::isVersion);
    }

    public boolean isPrivate() {
        return this.getModifiers().anySatisfy(AntlrModifier::isPrivate);
    }

    public boolean isCreatedBy() {
        return this.getModifiers().anySatisfy(AntlrModifier::isCreatedBy);
    }

    public boolean isFinal() {
        return this.getModifiers().anySatisfy(AntlrModifier::isFinal);
    }

    public boolean isLastUpdatedBy() {
        return this.getModifiers().anySatisfy(AntlrModifier::isLastUpdatedBy);
    }

    public boolean isDerived() {
        return this.getModifiers().anySatisfy(AntlrModifier::isDerived);
    }

    public int getNumModifiers() {
        return this.modifiers.size();
    }

    @Nonnull
    public ListIterable<AntlrModifier> getModifiers() {
        return this.modifiers.asUnmodifiable();
    }

    public void enterModifier(@Nonnull AntlrModifier modifier) {
        Objects.requireNonNull(modifier);
        this.modifiers.add((Object)modifier);
        ((MutableList)this.modifiersByName.getIfAbsentPut((Object)modifier.getKeyword(), () -> ((MutableListFactory)Lists.mutable).empty())).add((Object)modifier);
        AntlrModifier duplicate = (AntlrModifier)this.modifiersByContext.put((Object)modifier.getElementContext(), (Object)modifier);
        if (duplicate != null) {
            throw new AssertionError();
        }
    }

    public ImmutableList<AntlrModifier> getModifiersByName(String modifierName) {
        MutableList result = (MutableList)this.modifiersByName.get((Object)modifierName);
        return result == null ? Lists.immutable.empty() : result.toImmutable();
    }

    @OverridingMethodsMustInvokeSuper
    public void reportErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        this.reportDuplicateModifiers(compilerAnnotationHolder);
        this.reportDuplicateAuditModifiers(compilerAnnotationHolder);
        this.reportInvalidAuditProperties(compilerAnnotationHolder);
        this.reportDerivedPrivateProperty(compilerAnnotationHolder);
    }

    private void reportDuplicateModifiers(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        MutableBag duplicateModifiers = this.getModifiers().asLazy().collect(AntlrModifier::getKeyword).toBag().selectDuplicates();
        for (AntlrModifier modifier : this.getModifiers()) {
            if (!duplicateModifiers.contains((Object)modifier.getKeyword())) continue;
            String message = String.format("Duplicate modifier '%s'.", modifier.getKeyword());
            compilerAnnotationHolder.add("ERR_DUP_MOD", message, modifier);
        }
    }

    protected void reportDuplicateAuditModifiers(CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.isCreatedBy() && this.isLastUpdatedBy()) {
            ImmutableList modifiers = this.getModifiers().select((Predicate & Serializable)modifier -> modifier.isCreatedBy() || modifier.isLastUpdatedBy()).toImmutable();
            ImmutableList modifierContexts = modifiers.collect(AntlrElement::getElementContext);
            String message = "Property may not have both 'createdBy' and lastUpdatedBy' modifiers.";
            compilerAnnotationHolder.add("ERR_CBY_LBY", message, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)modifierContexts);
        }
    }

    @OverridingMethodsMustInvokeSuper
    protected void reportInvalidAuditProperties(CompilerAnnotationHolder compilerAnnotationHolder) {
        String message;
        if (this.isCreatedBy() && this.isLastUpdatedBy()) {
            return;
        }
        if (this.isCreatedBy() && !this.isFinal()) {
            AntlrModifier modifier = (AntlrModifier)this.getModifiers().detect(AntlrModifier::isCreatedBy);
            message = String.format("Expected createdBy property '%s' to be final.", this);
            compilerAnnotationHolder.add("ERR_CRT_FIN", message, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)modifier.getElementContext()));
        }
        if (this.isLastUpdatedBy() && this.isFinal()) {
            ImmutableList parserRuleContexts = this.getModifiers().select((Predicate & Serializable)antlrModifier -> antlrModifier.isLastUpdatedBy() || antlrModifier.isFinal()).collect(AntlrElement::getElementContext).toImmutable();
            message = String.format("Expected lastUpdatedBy property '%s' to not be final.", this);
            compilerAnnotationHolder.add("ERR_LUB_NFI", message, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)parserRuleContexts);
        }
    }

    public final void reportDuplicateMemberName(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        String message = String.format("Duplicate member: '%s.%s'.", this.getOwningClassifier().getName(), this.getName());
        compilerAnnotationHolder.add("ERR_DUP_PRP", message, this);
    }

    @OverridingMethodsMustInvokeSuper
    public void reportAuditErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        this.reportAuditErrors(compilerAnnotationHolder, (ListIterable<AntlrModifier>)this.modifiers, this);
    }

    public void reportDuplicatePropertyWithModifiers(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder, ImmutableList<String> modifierStrings) {
        ImmutableList modifiers = modifierStrings.flatCollect(this::getModifiersByName);
        String message = String.format("Multiple properties on '%s' with modifiers %s.", this.getOwningClassifier().getName(), modifierStrings);
        compilerAnnotationHolder.add("ERR_PRP_MOD", message, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)modifiers.collect(AntlrElement::getElementContext));
    }

    public void reportUnreferencedPrivateProperty(CompilerAnnotationHolder compilerAnnotationHolder) {
        boolean isAudit = this.isCreatedBy() || this.isLastUpdatedBy();
        String prefix = isAudit ? "Audit" : "Private";
        AnnotationSeverity severity = isAudit ? AnnotationSeverity.ERROR : AnnotationSeverity.WARNING;
        this.reportUnreferencedPrivateProperty(compilerAnnotationHolder, prefix, severity);
    }

    private void reportUnreferencedPrivateProperty(CompilerAnnotationHolder compilerAnnotationHolder, String prefix, AnnotationSeverity severity) {
        String message = "%s property '%s.%s' is not referenced in any criteria.".formatted(prefix, this.getOwningClassifier().getName(), this.getName());
        compilerAnnotationHolder.add("ERR_PRP_REF", message, (IAntlrElement)this, severity);
    }

    public void reportDerivedPrivateProperty(CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.isDerived() && this.isPrivate()) {
            AntlrModifier derivedModifier = (AntlrModifier)this.getModifiers().detect(AntlrModifier::isDerived);
            AntlrModifier privateModifier = (AntlrModifier)this.getModifiers().detect(AntlrModifier::isPrivate);
            String message = String.format("Derived property '%s' may not be private. Remove the 'private' modifier.", this);
            compilerAnnotationHolder.add("ERR_DRV_PRI", message, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)derivedModifier.getElementContext(), (Object)privateModifier.getElementContext()));
        }
    }

    @Override
    protected Pattern getNamePattern() {
        return MEMBER_NAME_PATTERN;
    }

    @Override
    public String toString() {
        return String.format("%s.%s", this.getOwningClassifier().getName(), this.getShortString());
    }

    public String getShortString() {
        MutableList sourceCodeStrings = org.eclipse.collections.api.factory.Lists.mutable.empty();
        String typeSourceCode = this.getType().getName();
        sourceCodeStrings.add((Object)typeSourceCode);
        this.getModifiers().asLazy().collect(AntlrElement::toString).into((Collection)sourceCodeStrings);
        return String.format("%s: %s", this.getName(), sourceCodeStrings.makeString(" "));
    }

    @Override
    public boolean isContext() {
        return true;
    }

    public abstract String getTypeName();
}

