/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state.service;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrElement;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.criteria.AntlrCriteria;
import cool.klass.model.converter.compiler.state.service.AntlrService;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.tuple.Pair;

public class AntlrServiceCriteria
extends AntlrElement {
    @Nonnull
    private final String serviceCriteriaKeyword;
    @Nonnull
    private final AntlrService service;
    private AntlrCriteria antlrCriteria;

    public AntlrServiceCriteria(@Nonnull KlassParser.ServiceCriteriaDeclarationContext elementContext, @Nonnull Optional<CompilationUnit> compilationUnit, @Nonnull String serviceCriteriaKeyword, @Nonnull AntlrService service) {
        super((ParserRuleContext)elementContext, compilationUnit);
        this.serviceCriteriaKeyword = Objects.requireNonNull(serviceCriteriaKeyword);
        this.service = Objects.requireNonNull(service);
    }

    @Override
    @Nonnull
    public Optional<IAntlrElement> getSurroundingElement() {
        return Optional.of(this.service);
    }

    @Override
    public boolean isContext() {
        return true;
    }

    @Override
    public Pair<Token, Token> getContextBefore() {
        return this.getEntireContext();
    }

    @Nonnull
    public AntlrCriteria getCriteria() {
        return Objects.requireNonNull(this.antlrCriteria);
    }

    public void setCriteria(@Nonnull AntlrCriteria antlrCriteria) {
        this.antlrCriteria = Objects.requireNonNull(antlrCriteria);
    }

    public void reportDuplicateKeyword(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        String message = String.format("Duplicate service criteria: '%s'.", this.serviceCriteriaKeyword);
        compilerAnnotationHolder.add("ERR_DUP_CRI", message, (IAntlrElement)this.antlrCriteria, (ParserRuleContext)this.getElementContext());
    }

    @Nonnull
    public KlassParser.ServiceCriteriaDeclarationContext getElementContext() {
        return (KlassParser.ServiceCriteriaDeclarationContext)super.getElementContext();
    }

    @Nonnull
    public String getServiceCriteriaKeyword() {
        return this.serviceCriteriaKeyword;
    }

    public void reportAllowedCriteriaTypes(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder, @Nonnull ImmutableList<String> allowedCriteriaTypes) {
        if (!allowedCriteriaTypes.contains((Object)this.serviceCriteriaKeyword)) {
            String error = String.format("Criteria '%s' not allowed for verb '%s'. Must be one of %s.", this.serviceCriteriaKeyword, this.service.getVerb().getVerb(), allowedCriteriaTypes);
            compilerAnnotationHolder.add("ERR_VRB_CRT", error, (IAntlrElement)this, (ParserRuleContext)this.getElementContext().serviceCriteriaKeyword());
        }
    }
}

