/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state.service.url;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrElement;
import cool.klass.model.converter.compiler.state.AntlrNamedElement;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.parameter.AntlrParameter;
import cool.klass.model.converter.compiler.state.property.ParameterHolder;
import cool.klass.model.converter.compiler.state.service.AntlrService;
import cool.klass.model.converter.compiler.state.service.AntlrServiceGroup;
import cool.klass.model.converter.compiler.state.service.AntlrVerb;
import cool.klass.model.converter.compiler.state.service.url.AntlrUrlConstant;
import cool.klass.model.meta.domain.AbstractElement;
import cool.klass.model.meta.domain.api.service.Verb;
import cool.klass.model.meta.domain.service.url.UrlImpl;
import cool.klass.model.meta.grammar.KlassParser;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.api.map.OrderedMap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;
import org.eclipse.collections.impl.tuple.Tuples;

public class AntlrUrl
extends AntlrElement {
    public static final AntlrUrl AMBIGUOUS = new AntlrUrl(new KlassParser.UrlDeclarationContext(AMBIGUOUS_PARENT, -1), Optional.empty(), AntlrServiceGroup.AMBIGUOUS);
    private static final Object SENTINEL = new Object(){

        public String toString() {
            return "SENTINEL";
        }
    };
    private final MutableList<IAntlrElement> urlPathSegments = Lists.mutable.empty();
    private final ParameterHolder urlParameters = new ParameterHolder();
    private final ParameterHolder pathParameters = new ParameterHolder();
    private final ParameterHolder queryParameters = new ParameterHolder();
    private final MutableList<AntlrService> services = Lists.mutable.empty();
    private final MutableOrderedMap<Verb, AntlrService> servicesByVerb = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<KlassParser.ServiceDeclarationContext, AntlrService> servicesByContext = OrderedMapAdapter.adapt(new LinkedHashMap());
    @Nonnull
    private final AntlrServiceGroup serviceGroup;
    private UrlImpl.UrlBuilder elementBuilder;

    public AntlrUrl(@Nonnull KlassParser.UrlDeclarationContext elementContext, @Nonnull Optional<CompilationUnit> compilationUnit, @Nonnull AntlrServiceGroup serviceGroup) {
        super((ParserRuleContext)elementContext, compilationUnit);
        this.serviceGroup = Objects.requireNonNull(serviceGroup);
    }

    @Override
    @Nonnull
    public Optional<IAntlrElement> getSurroundingElement() {
        return Optional.of(this.serviceGroup);
    }

    @Override
    public boolean isContext() {
        return true;
    }

    @Override
    public Pair<Token, Token> getContextBefore() {
        return Tuples.pair((Object)this.getElementContext().getStart(), (Object)this.getElementContext().url().getStop());
    }

    @Nonnull
    public AntlrServiceGroup getServiceGroup() {
        return this.serviceGroup;
    }

    public MutableList<AntlrService> getServices() {
        return this.services.asUnmodifiable();
    }

    public AntlrService getServiceByContext(KlassParser.ServiceDeclarationContext ctx) {
        return (AntlrService)this.servicesByContext.get((Object)ctx);
    }

    public int getNumPathSegments() {
        return this.urlPathSegments.size();
    }

    public int getNumQueryParameters() {
        return this.queryParameters.getNumParameters();
    }

    public void enterUrlConstant(AntlrUrlConstant antlrUrlConstant) {
        this.urlPathSegments.add((Object)antlrUrlConstant);
    }

    public void enterPathParameterDeclaration(@Nonnull AntlrParameter pathParameter) {
        this.urlPathSegments.add((Object)pathParameter);
        this.urlParameters.enterParameterDeclaration(pathParameter);
        this.pathParameters.enterParameterDeclaration(pathParameter);
    }

    public void enterQueryParameterDeclaration(@Nonnull AntlrParameter queryParameter) {
        this.urlParameters.enterParameterDeclaration(queryParameter);
        this.queryParameters.enterParameterDeclaration(queryParameter);
    }

    public void exitServiceDeclaration(@Nonnull AntlrService antlrService) {
        this.services.add((Object)antlrService);
        this.servicesByVerb.compute((Object)antlrService.getVerb().getVerb(), (name, builder) -> builder == null ? antlrService : AntlrService.AMBIGUOUS);
        AntlrService duplicate = (AntlrService)this.servicesByContext.put((Object)antlrService.getElementContext(), (Object)antlrService);
        if (duplicate != null) {
            throw new AssertionError();
        }
    }

    public void reportErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        this.reportDuplicateParameterErrors(compilerAnnotationHolder);
        this.reportDuplicateVerbErrors(compilerAnnotationHolder);
        this.reportNoVerbs(compilerAnnotationHolder);
        this.urlParameters.getParameters().forEachWith(AntlrParameter::reportErrors, (Object)compilerAnnotationHolder);
        this.services.forEachWith(AntlrService::reportErrors, (Object)compilerAnnotationHolder);
    }

    private void reportDuplicateParameterErrors(CompilerAnnotationHolder compilerAnnotationHolder) {
        ImmutableBag duplicateNames = this.urlParameters.getParameters().collect(AntlrNamedElement::getName).toBag().selectByOccurrences((IntPredicate & Serializable)occurrences -> occurrences > 1).toImmutable();
        this.urlParameters.getParameters().select((Predicate & Serializable)each -> duplicateNames.contains((Object)each.getName())).forEachWith(AntlrParameter::reportDuplicateParameterName, (Object)compilerAnnotationHolder);
    }

    private void reportDuplicateVerbErrors(CompilerAnnotationHolder compilerAnnotationHolder) {
        ImmutableBag duplicateVerbs = this.services.collect(AntlrService::getVerb).collect(AntlrVerb::getVerb).toBag().selectByOccurrences((IntPredicate & Serializable)occurrences -> occurrences > 1).toImmutable();
        this.services.select((Predicate & Serializable)each -> duplicateVerbs.contains((Object)each.getVerb().getVerb())).forEachWith(AntlrService::reportDuplicateVerb, (Object)compilerAnnotationHolder);
    }

    private void reportNoVerbs(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.services.isEmpty()) {
            String message = String.format("Service url should declare at least one verb: '%s'.", this.getElementContext().url().getText());
            compilerAnnotationHolder.add("ERR_URL_EMP", message, this);
        }
    }

    @Nonnull
    public KlassParser.UrlDeclarationContext getElementContext() {
        return (KlassParser.UrlDeclarationContext)super.getElementContext();
    }

    @Nonnull
    public OrderedMap<String, AntlrParameter> getFormalParametersByName() {
        return this.urlParameters.getParametersByName();
    }

    public ImmutableList<Object> getNormalizedPathSegments() {
        return this.urlPathSegments.collect(this::toNormalized).toImmutable();
    }

    @Nonnull
    private Object toNormalized(IAntlrElement element) {
        if (element instanceof AntlrParameter) {
            return SENTINEL;
        }
        if (element instanceof AntlrUrlConstant) {
            AntlrUrlConstant urlConstant = (AntlrUrlConstant)element;
            return urlConstant.getName();
        }
        throw new AssertionError();
    }

    @Nonnull
    public UrlImpl.UrlBuilder build() {
        if (this.elementBuilder != null) {
            throw new IllegalStateException();
        }
        this.elementBuilder = new UrlImpl.UrlBuilder((KlassParser.UrlDeclarationContext)this.elementContext, this.getMacroElementBuilder(), this.getSourceCodeBuilder(), this.serviceGroup.getElementBuilder());
        ImmutableList pathSegments = this.urlPathSegments.collect(this::buildPathSegment).toImmutable();
        this.elementBuilder.setPathSegmentBuilders(pathSegments);
        ImmutableList queryParameterBuilders = this.queryParameters.getParameters().collect(AntlrParameter::build).toImmutable();
        this.elementBuilder.setQueryParameterBuilders(queryParameterBuilders);
        ImmutableList pathParameterBuilders = this.pathParameters.getParameters().collect(AntlrParameter::getElementBuilder).toImmutable();
        this.elementBuilder.setPathParameterBuilders(pathParameterBuilders);
        ImmutableList parameterBuilders = this.urlParameters.getParameters().collect(AntlrParameter::getElementBuilder).toImmutable();
        this.elementBuilder.setParameterBuilders(parameterBuilders);
        ImmutableList serviceBuilders = this.services.collect(AntlrService::build).toImmutable();
        this.elementBuilder.setServiceBuilders(serviceBuilders);
        return this.elementBuilder;
    }

    @Nonnull
    private AbstractElement.ElementBuilder<?> buildPathSegment(IAntlrElement element) {
        if (element instanceof AntlrUrlConstant) {
            AntlrUrlConstant antlrUrlConstant = (AntlrUrlConstant)element;
            return antlrUrlConstant.build();
        }
        if (element instanceof AntlrParameter) {
            AntlrParameter antlrParameter = (AntlrParameter)element;
            return antlrParameter.build();
        }
        throw new AssertionError((Object)element.getClass().getSimpleName());
    }

    @Nonnull
    public UrlImpl.UrlBuilder getElementBuilder() {
        return Objects.requireNonNull(this.elementBuilder);
    }
}

