/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.data.store.reladomo;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.gs.fw.common.mithra.MithraDatedTransactionalObject;
import com.gs.fw.common.mithra.MithraList;
import com.gs.fw.common.mithra.MithraManagerProvider;
import com.gs.fw.common.mithra.MithraObject;
import com.gs.fw.common.mithra.MithraTransaction;
import com.gs.fw.common.mithra.MithraTransactionalObject;
import com.gs.fw.common.mithra.attribute.AsOfAttribute;
import com.gs.fw.common.mithra.attribute.Attribute;
import com.gs.fw.common.mithra.attribute.TimestampAttribute;
import com.gs.fw.common.mithra.finder.AbstractRelatedFinder;
import com.gs.fw.common.mithra.finder.RelatedFinder;
import com.gs.fw.common.mithra.util.DefaultInfinityTimestamp;
import com.gs.fw.finder.Operation;
import com.gs.fw.finder.TransactionalDomainList;
import cool.klass.data.store.DataStore;
import cool.klass.data.store.Transaction;
import cool.klass.data.store.TransactionalCommand;
import cool.klass.data.store.reladomo.OperationVisitor;
import cool.klass.data.store.reladomo.TransactionAdapter;
import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.Enumeration;
import cool.klass.model.meta.domain.api.EnumerationLiteral;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.PrimitiveType;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.property.EnumerationProperty;
import cool.klass.model.meta.domain.api.property.PrimitiveProperty;
import cool.klass.model.meta.domain.api.property.Property;
import cool.klass.model.meta.domain.api.property.ReferenceProperty;
import cool.klass.model.meta.domain.api.visitor.AssertObjectMatchesDataTypePropertyVisitor;
import cool.klass.model.meta.domain.api.visitor.DataTypePropertyVisitor;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.api.map.OrderedMap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;
import org.eclipse.collections.impl.tuple.Tuples;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ReladomoDataStore
implements DataStore {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"reladomo transaction stats");
    private static final Logger LOGGER = LoggerFactory.getLogger(ReladomoDataStore.class);
    private static final Converter<String, String> LOWER_TO_UPPER_CAMEL = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
    private static final Converter<String, String> UPPER_TO_LOWER_CAMEL = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);
    private final Supplier<UUID> uuidSupplier;
    private final int retryCount;
    private final MutableOrderedMap<Classifier, AbstractRelatedFinder> memoizedRelatedFinders = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<Pair<Class<?>, PrimitiveProperty>, Method> memoizedGenerateAndSetIdMethods = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<Property, Method> memoizedGetters = OrderedMapAdapter.adapt(new LinkedHashMap());

    public ReladomoDataStore(@Nonnull Supplier<UUID> uuidSupplier, int retryCount) {
        this.uuidSupplier = Objects.requireNonNull(uuidSupplier);
        this.retryCount = retryCount;
    }

    public <Result> Result runInTransaction(@Nonnull TransactionalCommand<Result> transactionalCommand) {
        return (Result)MithraManagerProvider.getMithraManager().executeTransactionalCommand(transaction -> {
            try {
                TransactionAdapter transactionAdapter = new TransactionAdapter(transaction);
                Object object = transactionalCommand.run((Transaction)transactionAdapter);
                return object;
            }
            finally {
                ReladomoDataStore.logTransactionalStats(transaction);
            }
        }, this.retryCount);
    }

    public void runInTransaction(@Nonnull Runnable runnable) {
        MithraManagerProvider.getMithraManager().executeTransactionalCommand(tx -> {
            runnable.run();
            return null;
        }, this.retryCount);
    }

    public List<Object> findAll(Klass klass) {
        AbstractRelatedFinder finder = this.getRelatedFinder((Classifier)klass);
        return finder.findMany((Operation)finder.all());
    }

    private static void logTransactionalStats(MithraTransaction reladomoTransaction) {
        if (MithraManagerProvider.getMithraManager().getCurrentTransaction() != reladomoTransaction) {
            throw new AssertionError();
        }
        MDC.put((String)"total database retrievals", (String)String.valueOf(MithraManagerProvider.getMithraManager().getDatabaseRetrieveCount()));
        MDC.put((String)"database retrievals", (String)String.valueOf(reladomoTransaction.getDatabaseRetrieveCount()));
        LOGGER.debug(MARKER, "total database retrievals: {} database retrievals: {}", (Object)MithraManagerProvider.getMithraManager().getDatabaseRetrieveCount(), (Object)reladomoTransaction.getDatabaseRetrieveCount());
        MDC.remove((String)"total database retrievals");
        MDC.remove((String)"database retrievals");
    }

    public Object findByKey(@Nonnull Klass klass, @Nonnull MapIterable<DataTypeProperty, Object> keys) {
        com.gs.fw.common.mithra.finder.Operation operation = this.getFindByKeyOperation(klass, keys);
        AbstractRelatedFinder finder = this.getRelatedFinder((Classifier)klass);
        return finder.findOne((Operation)operation);
    }

    public List<Object> findByKeyReturningList(Klass klass, MapIterable<DataTypeProperty, Object> keys) {
        com.gs.fw.common.mithra.finder.Operation operation = this.getFindByKeyOperation(klass, keys);
        AbstractRelatedFinder finder = this.getRelatedFinder((Classifier)klass);
        return finder.findMany((Operation)operation);
    }

    @Nonnull
    private com.gs.fw.common.mithra.finder.Operation getFindByKeyOperation(@Nonnull Klass klass, @Nonnull MapIterable<DataTypeProperty, Object> keys) {
        keys.forEachKeyValue((Procedure2 & Serializable)(keyProperty, keyValue) -> {
            if (keyProperty.getOwningClassifier() != klass) {
                String message = "Expected key property '%s' to be owned by the given class: '%s' but got '%s'.".formatted(keyProperty, klass, keyProperty.getOwningClassifier());
                throw new AssertionError((Object)message);
            }
        });
        ImmutableList keyProperties = klass.getKeyProperties();
        if (keyProperties.size() != keys.size()) {
            String error = String.format("Expected keys for properties %s but got the wrong number of keys %s", keyProperties, keys);
            throw new IllegalArgumentException(error);
        }
        AbstractRelatedFinder finder = this.getRelatedFinder((Classifier)klass);
        ImmutableList operations = keyProperties.collect(arg_0 -> this.lambda$getFindByKeyOperation$444ff66b$1(keys, (RelatedFinder)finder, arg_0));
        com.gs.fw.common.mithra.finder.Operation operation = (com.gs.fw.common.mithra.finder.Operation)operations.reduce(com.gs.fw.common.mithra.finder.Operation::and).get();
        return operation;
    }

    private com.gs.fw.common.mithra.finder.Operation getOperation(@Nonnull RelatedFinder<?> finder, @Nonnull DataTypeProperty keyProperty, Object key) {
        this.assertObjectMatchesType(keyProperty, key);
        Attribute attribute = finder.getAttributeByName(keyProperty.getName());
        OperationVisitor visitor = new OperationVisitor(attribute, key);
        keyProperty.visit((DataTypePropertyVisitor)visitor);
        return visitor.getResult();
    }

    private void assertObjectMatchesType(DataTypeProperty property, Object object) {
        property.visit((DataTypePropertyVisitor)new AssertObjectMatchesDataTypePropertyVisitor(object));
    }

    @Nonnull
    public Object instantiate(@Nonnull Klass klass, @Nonnull MapIterable<DataTypeProperty, Object> keys) {
        keys.each(Objects::requireNonNull);
        Object newInstance = this.instantiateNewInstance(klass);
        this.setKeys(klass, newInstance, keys);
        return newInstance;
    }

    @Nonnull
    private Object instantiateNewInstance(@Nonnull Klass klass) {
        try {
            Object[] objectArray;
            Class[] classArray;
            Class<?> aClass = Class.forName(klass.getFullyQualifiedName());
            if (klass.isSystemTemporal()) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Timestamp.class;
            } else {
                classArray = new Class[]{};
            }
            Class[] parameterTypes = classArray;
            Constructor<?> constructor = aClass.getConstructor(parameterTypes);
            if (klass.isSystemTemporal()) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = DefaultInfinityTimestamp.getDefaultInfinity();
            } else {
                objectArray = new Object[]{};
            }
            Object[] constructorArgs = objectArray;
            return constructor.newInstance(constructorArgs);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    private Object instantiateNewInstance(@Nonnull Klass klass, @Nonnull Instant validTime) {
        try {
            Class<?> aClass = Class.forName(klass.getFullyQualifiedName());
            Constructor<?> constructor = aClass.getConstructor(Timestamp.class, Timestamp.class);
            Timestamp timestamp = Timestamp.valueOf(LocalDateTime.ofInstant(validTime, ZoneOffset.UTC));
            return constructor.newInstance(timestamp, timestamp);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private void setKeys(@Nonnull Klass klass, @Nonnull Object newInstance, @Nonnull MapIterable<DataTypeProperty, Object> keys) {
        this.generateAndSetId(newInstance, klass);
        ImmutableList keyProperties = klass.getKeyProperties().reject(DataTypeProperty::isID);
        if (keyProperties.size() != keys.size()) {
            String error = String.format("Expected one key for each key property in %s but got %s", keyProperties, keys);
            throw new IllegalArgumentException(error);
        }
        for (DataTypeProperty keyProperty : keyProperties) {
            Object key = keys.get((Object)keyProperty);
            Objects.requireNonNull(key, () -> "Expected non-null key for property: " + String.valueOf(keyProperty));
            this.setDataTypeProperty(newInstance, keyProperty, key);
        }
    }

    private void generateAndSetId(@Nonnull Object persistentInstance, @Nonnull Klass klass) {
        ImmutableList idProperties = klass.getDataTypeProperties().select(DataTypeProperty::isID);
        if (idProperties.isEmpty()) {
            return;
        }
        PrimitiveProperty idProperty = (PrimitiveProperty)idProperties.getOnly();
        if (idProperty.getType().isNumeric()) {
            try {
                Method generateAndSetIdMethod = this.getGenerateAndSetIdMethod(persistentInstance.getClass(), idProperty);
                generateAndSetIdMethod.invoke(persistentInstance, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        } else if (idProperty.getType() == PrimitiveType.STRING) {
            Objects.requireNonNull(this.uuidSupplier);
            UUID uuid = this.uuidSupplier.get();
            String uuidString = uuid.toString();
            this.setDataTypeProperty(persistentInstance, (DataTypeProperty)idProperty, uuidString);
        } else {
            throw new AssertionError(idProperty);
        }
    }

    @Nonnull
    private Method getGenerateAndSetIdMethod(Class<?> klass, PrimitiveProperty idProperty) throws NoSuchMethodException {
        Pair key = Tuples.pair(klass, (Object)idProperty);
        if (this.memoizedGenerateAndSetIdMethods.containsKey((Object)key)) {
            return (Method)this.memoizedGenerateAndSetIdMethods.get((Object)key);
        }
        String methodName = "generateAndSet" + (String)LOWER_TO_UPPER_CAMEL.convert((Object)idProperty.getName());
        Method generateAndSetIdMethod = klass.getMethod(methodName, new Class[0]);
        this.memoizedGenerateAndSetIdMethods.put((Object)key, (Object)generateAndSetIdMethod);
        return generateAndSetIdMethod;
    }

    @Nullable
    public Object getDataTypeProperty(@Nonnull Object persistentInstance, @Nonnull DataTypeProperty dataTypeProperty) {
        String attributeName;
        Objects.requireNonNull(persistentInstance);
        if (!(persistentInstance instanceof MithraObject)) {
            String detailMessage = "Expected MithraObject but got " + persistentInstance.getClass().getCanonicalName();
            throw new AssertionError((Object)detailMessage);
        }
        if (dataTypeProperty.isDerived()) {
            return this.getPropertyReflectively(persistentInstance, (Property)dataTypeProperty);
        }
        Classifier owningClassifier = dataTypeProperty.getOwningClassifier();
        if (owningClassifier instanceof Klass && !Objects.equals(owningClassifier.getName(), persistentInstance.getClass().getSimpleName())) {
            String detailMessage = "Expected %s but got %s".formatted(owningClassifier.getName(), persistentInstance.getClass().getSimpleName());
            throw new AssertionError((Object)detailMessage);
        }
        RelatedFinder<?> finder = this.getRelatedFinder((MithraObject)persistentInstance);
        Attribute attribute = finder.getAttributeByName(attributeName = dataTypeProperty.getName());
        if (attribute == null) {
            String detailMessage = "Domain model and generated code are out of sync. Try rerunning a full clean build. Could not find attribute: " + attributeName;
            throw new AssertionError((Object)detailMessage);
        }
        if (attribute.isAttributeNull(persistentInstance)) {
            if (dataTypeProperty.isOptional()) {
                return null;
            }
            String message = String.format("Found null for required property: '%s'", dataTypeProperty);
            throw new IllegalStateException(message);
        }
        Object result = attribute.valueOf(persistentInstance);
        if (dataTypeProperty.getType() == PrimitiveType.LOCAL_DATE) {
            return ((Date)result).toLocalDate();
        }
        if (dataTypeProperty.getType() == PrimitiveType.INSTANT) {
            return ((Timestamp)result).toInstant();
        }
        if (dataTypeProperty.isTemporalRange()) {
            Timestamp infinity = ((AsOfAttribute)attribute).getInfinityDate();
            if (infinity.equals(result)) {
                return null;
            }
            return ((Timestamp)result).toInstant();
        }
        if (dataTypeProperty.isTemporalInstant()) {
            Timestamp infinity = ((TimestampAttribute)attribute).getAsOfAttributeInfinity();
            if (infinity.equals(result)) {
                return null;
            }
            return ((Timestamp)result).toInstant();
        }
        if (dataTypeProperty instanceof EnumerationProperty) {
            EnumerationProperty enumerationProperty = (EnumerationProperty)dataTypeProperty;
            String prettyName = (String)result;
            Enumeration enumeration = enumerationProperty.getType();
            Optional enumerationLiteral = enumeration.getEnumerationLiterals().detectOptional((Predicate & Serializable)each -> each.getPrettyName().equals(prettyName));
            return enumerationLiteral.orElseThrow(() -> new AssertionError((Object)prettyName));
        }
        return result;
    }

    @Nullable
    private Object getDataTypePropertyLenient(@Nonnull Object persistentInstance, @Nonnull DataTypeProperty dataTypeProperty) {
        if (dataTypeProperty.isDerived()) {
            return this.getPropertyReflectively(persistentInstance, (Property)dataTypeProperty);
        }
        RelatedFinder<?> finder = this.getRelatedFinder((MithraObject)persistentInstance);
        Attribute attribute = finder.getAttributeByName(dataTypeProperty.getName());
        if (attribute == null) {
            String detailMessage = "Domain model and generated code are out of sync. Try rerunning a full clean build. Could not find: " + String.valueOf(dataTypeProperty);
            throw new AssertionError((Object)detailMessage);
        }
        if (attribute.isAttributeNull(persistentInstance)) {
            return null;
        }
        Object result = attribute.valueOf(persistentInstance);
        if (dataTypeProperty.getType() == PrimitiveType.LOCAL_DATE) {
            return ((Date)result).toLocalDate();
        }
        if (dataTypeProperty.getType() == PrimitiveType.INSTANT) {
            return ((Timestamp)result).toInstant();
        }
        boolean isTemporal = dataTypeProperty.isTemporal();
        if (isTemporal) {
            Timestamp infinity = ((TimestampAttribute)attribute).getAsOfAttributeInfinity();
            if (infinity.equals(result)) {
                return null;
            }
            return ((Timestamp)result).toInstant();
        }
        if (dataTypeProperty instanceof EnumerationProperty) {
            EnumerationProperty enumerationProperty = (EnumerationProperty)dataTypeProperty;
            String prettyName = (String)result;
            Enumeration enumeration = enumerationProperty.getType();
            Optional enumerationLiteral = enumeration.getEnumerationLiterals().detectOptional((Predicate & Serializable)each -> each.getPrettyName().equals(prettyName));
            return enumerationLiteral.orElseThrow(() -> new AssertionError((Object)prettyName));
        }
        return result;
    }

    private Object getPropertyReflectively(@Nonnull Object persistentInstance, @Nonnull Property property) {
        try {
            Method method = this.getMethod(property);
            return method.invoke(persistentInstance, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    private Method getMethod(@Nonnull Property property) throws ClassNotFoundException, NoSuchMethodException {
        if (this.memoizedGetters.containsKey((Object)property)) {
            return (Method)this.memoizedGetters.get((Object)property);
        }
        Classifier owningClassifier = property.getOwningClassifier();
        String fullyQualifiedName = owningClassifier.getFullyQualifiedName();
        Class<?> aClass = Class.forName(fullyQualifiedName);
        String methodName = this.getMethodName(property);
        Method method = aClass.getMethod(methodName, new Class[0]);
        this.memoizedGetters.put((Object)property, (Object)method);
        return method;
    }

    @Nonnull
    private String getMethodName(Property property) {
        String prefix = property.getType() == PrimitiveType.BOOLEAN ? "is" : "get";
        String suffix = (String)LOWER_TO_UPPER_CAMEL.convert((Object)property.getName());
        return prefix + suffix;
    }

    public boolean setDataTypeProperty(@Nonnull Object persistentInstance, @Nonnull DataTypeProperty dataTypeProperty, @Nullable Object newValue) {
        if (dataTypeProperty.isDerived()) {
            String detailMessage = "May not set derived property: " + String.valueOf(dataTypeProperty);
            throw new AssertionError((Object)detailMessage);
        }
        Object oldValue = this.getDataTypePropertyLenient(persistentInstance, dataTypeProperty);
        if (Objects.equals(oldValue, newValue)) {
            return false;
        }
        RelatedFinder<?> finder = this.getRelatedFinder((MithraObject)persistentInstance);
        Attribute attribute = finder.getAttributeByName(dataTypeProperty.getName());
        if (newValue == null) {
            if (dataTypeProperty.isRequired()) {
                String message = String.format("May not set required property to null: '%s.%s'", dataTypeProperty.getOwningClassifier().getName(), dataTypeProperty);
                throw new IllegalStateException(message);
            }
            attribute.setValueNull(persistentInstance);
        } else if (dataTypeProperty instanceof EnumerationProperty) {
            attribute.setValue(persistentInstance, (Object)((EnumerationLiteral)newValue).getPrettyName());
        } else if (dataTypeProperty.getType() == PrimitiveType.LOCAL_DATE) {
            Timestamp timestamp = Timestamp.valueOf(((LocalDate)newValue).atStartOfDay());
            attribute.setValue(persistentInstance, (Object)timestamp);
        } else if (dataTypeProperty.getType() == PrimitiveType.INSTANT) {
            Timestamp timestamp = Timestamp.from((Instant)newValue);
            attribute.setValue(persistentInstance, (Object)timestamp);
        } else {
            attribute.setValue(persistentInstance, newValue);
        }
        return true;
    }

    public Object getToOne(Object persistentSourceInstance, @Nonnull ReferenceProperty referenceProperty) {
        if (!referenceProperty.getMultiplicity().isToOne()) {
            String detailMessage = "Expected to-one property but got " + String.valueOf(referenceProperty);
            throw new AssertionError((Object)detailMessage);
        }
        Object result = this.get(persistentSourceInstance, referenceProperty);
        if (result instanceof List) {
            List list = (List)result;
            String detailMessage = "Expected single object but got " + list.size();
            throw new AssertionError((Object)detailMessage);
        }
        return result;
    }

    public Object get(Object persistentSourceInstance, @Nonnull ReferenceProperty referenceProperty) {
        String referencePropertyName;
        AbstractRelatedFinder finder = this.getRelatedFinder(referenceProperty.getOwningClassifier());
        AbstractRelatedFinder relationshipFinder = (AbstractRelatedFinder)finder.getRelationshipFinderByName(referencePropertyName = referenceProperty.getName());
        if (relationshipFinder == null) {
            String detailMessage = "Domain model and generated code are out of sync. Try rerunning a full clean build. Could not find relationship for property " + String.valueOf(referenceProperty);
            throw new AssertionError((Object)detailMessage);
        }
        return relationshipFinder.valueOf(persistentSourceInstance);
    }

    @Nonnull
    public List<Object> getToMany(Object persistentSourceInstance, @Nonnull ReferenceProperty referenceProperty) {
        if (!referenceProperty.getMultiplicity().isToMany()) {
            String detailMessage = "Expected to-many property but got " + String.valueOf(referenceProperty);
            throw new AssertionError((Object)detailMessage);
        }
        Object result = this.get(persistentSourceInstance, referenceProperty);
        if (!(result instanceof List)) {
            String detailMessage = "Expected list but got " + result.getClass().getCanonicalName();
            throw new AssertionError((Object)detailMessage);
        }
        return (List)result;
    }

    public boolean setToOne(@Nonnull Object persistentSourceInstance, @Nonnull AssociationEnd associationEnd, @Nonnull Object persistentTargetInstance) {
        Objects.requireNonNull(persistentTargetInstance);
        boolean mutationOccurred = false;
        ImmutableList targetDataTypeProperties = associationEnd.getOwningClassifier().getDataTypeProperties();
        for (DataTypeProperty targetDataTypeProperty : targetDataTypeProperties) {
            OrderedMap keysMatchingThisForeignKey = targetDataTypeProperty.getKeysMatchingThisForeignKey();
            DataTypeProperty keyInRelatedObject = (DataTypeProperty)keysMatchingThisForeignKey.getIfAbsentValue((Object)associationEnd, null);
            if (keyInRelatedObject == null) continue;
            DataTypeProperty foreignKey = targetDataTypeProperty;
            Object keyValue = this.getDataTypeProperty(persistentTargetInstance, keyInRelatedObject);
            mutationOccurred |= this.setDataTypeProperty(persistentSourceInstance, foreignKey, keyValue);
        }
        return mutationOccurred;
    }

    public void insert(Object persistentInstance) {
        if (!(persistentInstance instanceof MithraTransactionalObject)) {
            String detailMessage = "Expected MithraTransactionalObject but got " + persistentInstance.getClass().getCanonicalName();
            throw new AssertionError((Object)detailMessage);
        }
        ((MithraTransactionalObject)persistentInstance).insert();
    }

    public void deleteOrTerminate(@Nonnull Object persistentInstance) {
        if (persistentInstance instanceof MithraDatedTransactionalObject) {
            MithraDatedTransactionalObject transactionalObject = (MithraDatedTransactionalObject)persistentInstance;
            transactionalObject.terminate();
        } else if (persistentInstance instanceof MithraTransactionalObject) {
            MithraTransactionalObject transactionalObject = (MithraTransactionalObject)persistentInstance;
            transactionalObject.delete();
        } else {
            String detailMessage = "Unexpected persistent instance type: " + persistentInstance.getClass().getCanonicalName();
            throw new AssertionError((Object)detailMessage);
        }
    }

    public void purgeAll(@Nonnull Klass klass) {
        if (klass.isAbstract()) {
            return;
        }
        AbstractRelatedFinder relatedFinder = this.getRelatedFinder((Classifier)klass);
        if (klass.isSystemTemporal()) {
            this.purgeAll((RelatedFinder<?>)relatedFinder);
        } else {
            this.deleteAll((RelatedFinder<?>)relatedFinder);
        }
    }

    private void purgeAll(RelatedFinder<?> relatedFinder) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".purgeAll() not implemented yet");
    }

    private void deleteAll(@Nonnull RelatedFinder<?> finder) {
        com.gs.fw.common.mithra.finder.Operation operation = finder.all();
        MithraList mithraList = finder.findMany((Operation)operation);
        TransactionalDomainList transactionalDomainList = (TransactionalDomainList)mithraList;
        transactionalDomainList.deleteAll();
    }

    public boolean isInstanceOf(@Nonnull Object persistentInstance, @Nonnull Classifier classifier) {
        try {
            Class<?> persistentInstanceClass = persistentInstance.getClass();
            Class<?> domainModelClass = Class.forName(classifier.getPackageName() + "." + classifier.getName());
            return domainModelClass.isAssignableFrom(persistentInstanceClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Klass getMostSpecificSubclass(Object persistentInstance, Klass klass) {
        if (!(persistentInstance instanceof MithraObject)) {
            String detailMessage = "Expected MithraObject but got " + persistentInstance.getClass().getCanonicalName();
            throw new AssertionError((Object)detailMessage);
        }
        ImmutableList potentialSubClasses = klass.getSubClasses().select((Predicate & Serializable)subClass -> {
            MithraObject subClassPersistentInstance = this.getSubClassPersistentInstance(klass, (Klass)subClass, (MithraObject)persistentInstance);
            return subClassPersistentInstance != null;
        });
        if (potentialSubClasses.isEmpty()) {
            return klass;
        }
        if (potentialSubClasses.size() == 1) {
            Klass onlySubClass = (Klass)potentialSubClasses.getOnly();
            MithraObject subClassPersistentInstance = this.getSubClassPersistentInstance(klass, onlySubClass, (MithraObject)persistentInstance);
            Klass result = this.getMostSpecificSubclass(subClassPersistentInstance, onlySubClass);
            return result;
        }
        String detailMessage = "Expected one subclass but got " + String.valueOf(potentialSubClasses);
        throw new AssertionError((Object)detailMessage);
    }

    public MithraObject getSubClassPersistentInstance(Klass klass, Klass subClass, MithraObject persistentInstance) {
        String relationshipName;
        AbstractRelatedFinder finder = this.getRelatedFinder((Classifier)klass);
        AbstractRelatedFinder relationshipFinder = (AbstractRelatedFinder)finder.getRelationshipFinderByName(relationshipName = (String)UPPER_TO_LOWER_CAMEL.convert((Object)subClass.getName()) + "SubClass");
        if (relationshipFinder == null) {
            String detailMessage = "Domain model and generated code are out of sync. Try rerunning a full clean build. Could not find relationship for property " + relationshipName;
            throw new AssertionError((Object)detailMessage);
        }
        Object result = relationshipFinder.valueOf((Object)persistentInstance);
        return (MithraObject)result;
    }

    public Object getSuperClass(Object persistentInstance, Klass klass) {
        String relationshipName;
        AbstractRelatedFinder finder = this.getRelatedFinder((Classifier)klass);
        AbstractRelatedFinder relationshipFinder = (AbstractRelatedFinder)finder.getRelationshipFinderByName(relationshipName = (String)UPPER_TO_LOWER_CAMEL.convert((Object)((Klass)klass.getSuperClass().get()).getName()) + "SuperClass");
        if (relationshipFinder == null) {
            String detailMessage = "Domain model and generated code are out of sync. Try rerunning a full clean build. Could not find relationship for property " + relationshipName;
            throw new AssertionError((Object)detailMessage);
        }
        Object result = relationshipFinder.valueOf(persistentInstance);
        Objects.requireNonNull(result, () -> "Expected result to not be null for superClass: %s, persistentInstance: %s".formatted(klass, persistentInstance));
        return result;
    }

    public Object getSubClass(Object persistentInstance, Klass superClass, Klass subClass) {
        String relationshipName;
        if (!subClass.isStrictSubTypeOf((Classifier)superClass)) {
            throw new AssertionError((Object)("Expected " + String.valueOf(subClass) + " to be a strict subtype of " + String.valueOf(superClass)));
        }
        AbstractRelatedFinder finder = this.getRelatedFinder((Classifier)superClass);
        AbstractRelatedFinder relationshipFinder = (AbstractRelatedFinder)finder.getRelationshipFinderByName(relationshipName = (String)UPPER_TO_LOWER_CAMEL.convert((Object)subClass.getName()) + "SubClass");
        if (relationshipFinder == null) {
            String detailMessage = "Domain model and generated code are out of sync. Try rerunning a full clean build. Could not find relationship for property " + relationshipName;
            throw new AssertionError((Object)detailMessage);
        }
        Object result = relationshipFinder.valueOf(persistentInstance);
        return result;
    }

    private RelatedFinder<?> getRelatedFinder(@Nonnull MithraObject mithraObject) {
        return mithraObject.zGetPortal().getFinder();
    }

    @Nonnull
    public AbstractRelatedFinder getRelatedFinder(@Nonnull Classifier classifier) {
        if (this.memoizedRelatedFinders.containsKey((Object)classifier)) {
            return (AbstractRelatedFinder)this.memoizedRelatedFinders.get((Object)classifier);
        }
        try {
            String finderName = classifier.getFullyQualifiedName() + "Finder";
            Class<?> finderClass = Class.forName(finderName);
            Method getFinderMethod = finderClass.getMethod("getFinderInstance", new Class[0]);
            AbstractRelatedFinder result = (AbstractRelatedFinder)getFinderMethod.invoke(null, new Object[0]);
            this.memoizedRelatedFinders.put((Object)classifier, (Object)result);
            return result;
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private /* synthetic */ com.gs.fw.common.mithra.finder.Operation lambda$getFindByKeyOperation$444ff66b$1(MapIterable keys, RelatedFinder finder, DataTypeProperty keyProperty) {
        Object key = keys.get((Object)keyProperty);
        if (!keys.containsKey((Object)keyProperty)) {
            String detailMessage = "Expected key for property: " + String.valueOf(keyProperty);
            throw new AssertionError((Object)detailMessage);
        }
        if (key == null) {
            String detailMessage = "Expected non-null key for property: " + String.valueOf(keyProperty);
            throw new AssertionError((Object)detailMessage);
        }
        return this.getOperation(finder, keyProperty, key);
    }
}

