/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.data.store;

import cool.klass.data.store.TransactionalCommand;
import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.property.ReferenceProperty;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.collections.api.map.MapIterable;

public interface DataStore {
    public <Result> Result runInTransaction(TransactionalCommand<Result> var1);

    public void runInTransaction(Runnable var1);

    public List<Object> findAll(Klass var1);

    public Object findByKey(Klass var1, MapIterable<DataTypeProperty, Object> var2);

    public List<Object> findByKeyReturningList(Klass var1, MapIterable<DataTypeProperty, Object> var2);

    default public Object getReferenceProperty(Object persistentInstance, ReferenceProperty referenceProperty) {
        if (referenceProperty.getMultiplicity().isToOne()) {
            return this.getToOne(persistentInstance, referenceProperty);
        }
        if (referenceProperty.getMultiplicity().isToMany()) {
            return this.getToMany(persistentInstance, referenceProperty);
        }
        throw new IllegalStateException("Unknown multiplicity: " + referenceProperty.getMultiplicity());
    }

    public Object getToOne(Object var1, @Nonnull ReferenceProperty var2);

    @Nonnull
    public List<Object> getToMany(Object var1, ReferenceProperty var2);

    @Nullable
    public Object getDataTypeProperty(Object var1, DataTypeProperty var2);

    public boolean setDataTypeProperty(Object var1, DataTypeProperty var2, Object var3);

    @Nonnull
    public Object instantiate(Klass var1, MapIterable<DataTypeProperty, Object> var2);

    public void insert(Object var1);

    public boolean setToOne(Object var1, AssociationEnd var2, Object var3);

    public void deleteOrTerminate(@Nonnull Object var1);

    public void purgeAll(@Nonnull Klass var1);

    public boolean isInstanceOf(Object var1, Classifier var2);

    public Klass getMostSpecificSubclass(Object var1, Klass var2);

    public Object getSuperClass(Object var1, Klass var2);

    public Object getSubClass(Object var1, Klass var2, Klass var3);
}

