/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.deserializer.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import cool.klass.deserializer.json.JsonPrimitiveTypeValueVisitor;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.AssociationEndSignature;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.property.EnumerationProperty;
import cool.klass.model.meta.domain.api.property.ParameterizedProperty;
import cool.klass.model.meta.domain.api.property.PrimitiveProperty;
import cool.klass.model.meta.domain.api.property.PropertyVisitor;
import cool.klass.model.meta.domain.api.visitor.PrimitiveTypeVisitor;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.collections.api.block.predicate.Predicate;

public class JsonDataTypeValueVisitor
implements PropertyVisitor {
    private final JsonNode jsonDataTypeValue;
    private Object result;

    public JsonDataTypeValueVisitor(JsonNode jsonDataTypeValue) {
        this.jsonDataTypeValue = Objects.requireNonNull(jsonDataTypeValue);
    }

    public static boolean dataTypePropertyIsNullInJson(@Nonnull DataTypeProperty dataTypeProperty, @Nonnull ObjectNode incomingJson) {
        JsonNode jsonDataTypeValue = incomingJson.path(dataTypeProperty.getName());
        return jsonDataTypeValue.isMissingNode() || jsonDataTypeValue.isNull();
    }

    @Nullable
    public static Object extractDataTypePropertyFromJson(@Nonnull DataTypeProperty dataTypeProperty, @Nonnull ObjectNode incomingJson) {
        JsonNode jsonDataTypeValue = incomingJson.path(dataTypeProperty.getName());
        if (jsonDataTypeValue.isMissingNode() || jsonDataTypeValue.isNull()) {
            return null;
        }
        JsonDataTypeValueVisitor visitor = new JsonDataTypeValueVisitor(jsonDataTypeValue);
        dataTypeProperty.visit((PropertyVisitor)visitor);
        return visitor.getResult();
    }

    public Object getResult() {
        return this.result;
    }

    public void visitPrimitiveProperty(@Nonnull PrimitiveProperty primitiveProperty) {
        JsonPrimitiveTypeValueVisitor visitor = new JsonPrimitiveTypeValueVisitor(this.jsonDataTypeValue);
        primitiveProperty.getType().visit((PrimitiveTypeVisitor)visitor);
        this.result = visitor.getResult();
    }

    public void visitEnumerationProperty(@Nonnull EnumerationProperty enumerationProperty) {
        if (!this.jsonDataTypeValue.isTextual()) {
            throw new AssertionError();
        }
        String textValue = this.jsonDataTypeValue.textValue();
        Optional enumerationLiteral = enumerationProperty.getType().getEnumerationLiterals().detectOptional((Predicate & Serializable)each -> each.getPrettyName().equals(textValue));
        this.result = enumerationLiteral.get();
    }

    public void visitAssociationEndSignature(AssociationEndSignature associationEndSignature) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".visitAssociationEndSignature() not implemented yet");
    }

    public void visitAssociationEnd(@Nonnull AssociationEnd associationEnd) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".visitAssociationEnd() not implemented yet");
    }

    public void visitParameterizedProperty(@Nonnull ParameterizedProperty parameterizedProperty) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".visitParameterizedProperty() not implemented yet");
    }
}

