/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.deserializer.json;

import com.fasterxml.jackson.databind.JsonNode;
import cool.klass.model.meta.domain.api.modifier.Modifier;
import cool.klass.model.meta.domain.api.property.PrimitiveProperty;
import cool.klass.model.meta.domain.api.visitor.PrimitiveTypeVisitor;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.stack.MutableStack;

public class JsonTypeCheckingPrimitiveTypeVisitor
implements PrimitiveTypeVisitor {
    @Nonnull
    private final PrimitiveProperty primitiveProperty;
    @Nonnull
    private final JsonNode jsonDataTypeValue;
    @Nonnull
    private final MutableStack<String> contextStack;
    @Nonnull
    private final MutableList<String> errors;

    public JsonTypeCheckingPrimitiveTypeVisitor(PrimitiveProperty primitiveProperty, JsonNode jsonDataTypeValue, MutableStack<String> contextStack, MutableList<String> errors) {
        this.primitiveProperty = Objects.requireNonNull(primitiveProperty);
        this.jsonDataTypeValue = Objects.requireNonNull(jsonDataTypeValue);
        this.contextStack = Objects.requireNonNull(contextStack);
        this.errors = Objects.requireNonNull(errors);
    }

    private void emitTypeError() {
        String contextString = this.contextStack.toList().asReversed().makeString(".");
        String error = String.format("Error at %s. Expected property with type '%s.%s: %s%s' but got '%s' with type '%s'.", contextString, this.primitiveProperty.getOwningClassifier().getName(), this.primitiveProperty.getName(), this.primitiveProperty.getType().getPrettyName(), this.primitiveProperty.isOptional() ? "?" : "", this.jsonDataTypeValue, this.jsonDataTypeValue.getNodeType().toString().toLowerCase());
        this.errors.add((Object)error);
    }

    public void visitString() {
        if (!this.jsonDataTypeValue.isTextual()) {
            this.emitTypeError();
        }
    }

    public void visitInteger() {
        if (!this.jsonDataTypeValue.isIntegralNumber() || !this.jsonDataTypeValue.canConvertToInt()) {
            this.emitTypeError();
        }
    }

    public void visitLong() {
        if (!this.jsonDataTypeValue.isIntegralNumber() || !this.jsonDataTypeValue.canConvertToLong()) {
            this.emitTypeError();
        }
    }

    public void visitDouble() {
        if (!(this.jsonDataTypeValue.isDouble() || this.jsonDataTypeValue.isFloat() || this.jsonDataTypeValue.isInt() || this.jsonDataTypeValue.isLong())) {
            this.emitTypeError();
        }
    }

    public void visitFloat() {
        if (!((this.jsonDataTypeValue.isDouble() || this.jsonDataTypeValue.isFloat() || this.jsonDataTypeValue.isInt() || this.jsonDataTypeValue.isLong()) && this.hasValidFloatString())) {
            this.emitTypeError();
        }
    }

    private boolean hasValidFloatString() {
        double doubleValue = this.jsonDataTypeValue.doubleValue();
        float floatValue = this.jsonDataTypeValue.floatValue();
        String doubleString = Double.toString(doubleValue);
        String floatString = Float.toString(floatValue);
        return doubleString.equals(floatString);
    }

    public void visitBoolean() {
        if (!this.jsonDataTypeValue.isBoolean()) {
            this.emitTypeError();
        }
    }

    public void visitInstant() {
        this.visitTemporal();
    }

    public void visitLocalDate() {
        if (!this.jsonDataTypeValue.isTextual()) {
            this.emitTypeError();
            return;
        }
        String text = this.jsonDataTypeValue.textValue();
        if (text.equals("now") || text.equals("infinity")) {
            return;
        }
        try {
            LocalDate.parse(text);
        }
        catch (DateTimeParseException e) {
            String error = String.format("Error at %s. Expected property with type '%s' but got '%s' which could not be parsed by LocalDate.parse() which expects a String like '1999-12-31.", this.getContextString(), this.primitiveProperty, this.jsonDataTypeValue);
            this.errors.add((Object)error);
        }
    }

    public void visitTemporalInstant() {
        this.visitTemporal();
    }

    public void visitTemporalRange() {
        this.visitTemporal();
    }

    private void visitTemporal() {
        if (this.jsonDataTypeValue.isNull() && this.primitiveProperty.isTemporalInstant() && this.primitiveProperty.getModifiers().anySatisfy(Modifier::isTo)) {
            return;
        }
        if (!this.jsonDataTypeValue.isTextual()) {
            this.emitTypeError();
            return;
        }
        String text = this.jsonDataTypeValue.textValue();
        if (text.equals("now") || text.equals("infinity")) {
            return;
        }
        try {
            Instant.parse(text);
        }
        catch (DateTimeParseException e) {
            String error = String.format("Error at %s. Expected property with type '%s' but got '%s' which could not be parsed by java.time.format.DateTimeFormatter.ISO_INSTANT which expects a String like '1999-12-31T23:59:59Z'", this.getContextString(), this.primitiveProperty, this.jsonDataTypeValue);
            this.errors.add((Object)error);
        }
    }

    protected String getContextString() {
        return this.contextStack.toList().asReversed().makeString(".");
    }
}

