/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.deserializer.json.context;

import cool.klass.deserializer.json.context.ErrorContext;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.tuple.Pair;

public class AssociationEndErrorContext
implements ErrorContext {
    private final AssociationEnd associationEnd;
    private final ImmutableList<Object> keys;

    public AssociationEndErrorContext(AssociationEnd associationEnd, ImmutableList<Object> keys) {
        this.associationEnd = Objects.requireNonNull(associationEnd);
        this.keys = Objects.requireNonNull(keys);
    }

    public String toString() {
        ImmutableList keyProperties = this.associationEnd.getType().getKeyProperties();
        if (keyProperties.size() != this.keys.size()) {
            throw new AssertionError();
        }
        String keysContext = keyProperties.asLazy().zip(this.keys).collect(AssociationEndErrorContext::toString).makeString();
        String format = this.associationEnd.getMultiplicity().isToMany() ? "%s[%s]" : "%s{%s}";
        return String.format(format, this.associationEnd.getName(), keysContext);
    }

    private static String toString(@Nonnull Pair<DataTypeProperty, Object> pair) {
        DataTypeProperty dataTypeProperty = (DataTypeProperty)pair.getOne();
        Object key = pair.getTwo();
        return String.format("%s=%s", dataTypeProperty.getName(), key);
    }
}

