/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.deserializer.json;

import com.fasterxml.jackson.databind.JsonNode;
import cool.klass.model.meta.domain.api.visitor.PrimitiveTypeVisitor;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.Objects;

public class JsonPrimitiveTypeValueVisitor
implements PrimitiveTypeVisitor {
    private final JsonNode jsonDataTypeValue;
    private Object result;

    public JsonPrimitiveTypeValueVisitor(JsonNode jsonDataTypeValue) {
        this.jsonDataTypeValue = Objects.requireNonNull(jsonDataTypeValue);
    }

    public Object getResult() {
        return this.result;
    }

    public void visitString() {
        if (!this.jsonDataTypeValue.isTextual()) {
            throw new AssertionError();
        }
        this.result = this.jsonDataTypeValue.textValue();
    }

    public void visitInteger() {
        if (!this.jsonDataTypeValue.isIntegralNumber() || !this.jsonDataTypeValue.canConvertToInt()) {
            throw new AssertionError();
        }
        this.result = this.jsonDataTypeValue.intValue();
    }

    public void visitLong() {
        if (!this.jsonDataTypeValue.isIntegralNumber() || !this.jsonDataTypeValue.canConvertToLong()) {
            throw new AssertionError();
        }
        this.result = this.jsonDataTypeValue.longValue();
    }

    public void visitDouble() {
        if (!(this.jsonDataTypeValue.isDouble() || this.jsonDataTypeValue.isFloat() || this.jsonDataTypeValue.isInt() || this.jsonDataTypeValue.isLong())) {
            throw new AssertionError();
        }
        this.result = this.jsonDataTypeValue.doubleValue();
    }

    public void visitFloat() {
        if (!((this.jsonDataTypeValue.isDouble() || this.jsonDataTypeValue.isFloat() || this.jsonDataTypeValue.isInt() || this.jsonDataTypeValue.isLong()) && this.hasValidFloatString())) {
            throw new AssertionError();
        }
        this.result = Float.valueOf(this.jsonDataTypeValue.floatValue());
    }

    private boolean hasValidFloatString() {
        double doubleValue = this.jsonDataTypeValue.doubleValue();
        float floatValue = this.jsonDataTypeValue.floatValue();
        String doubleString = Double.toString(doubleValue);
        String floatString = Float.toString(floatValue);
        return doubleString.equals(floatString);
    }

    public void visitBoolean() {
        if (!this.jsonDataTypeValue.isBoolean()) {
            throw new AssertionError();
        }
        this.result = this.jsonDataTypeValue.booleanValue();
    }

    public void visitInstant() {
        this.visitTemporal();
    }

    public void visitLocalDate() {
        if (!this.jsonDataTypeValue.isTextual()) {
            throw new AssertionError();
        }
        String text = this.jsonDataTypeValue.textValue();
        if (text.equals("now")) {
            throw new RuntimeException("TODO: Support 'now' as a value for dates.");
        }
        if (text.equals("infinity")) {
            throw new RuntimeException("TODO: Support 'infinity' as a value for dates.");
        }
        this.result = LocalDate.parse(text);
    }

    public void visitTemporalInstant() {
        this.visitTemporal();
    }

    public void visitTemporalRange() {
        this.visitTemporal();
    }

    private void visitTemporal() {
        if (!this.jsonDataTypeValue.isTextual()) {
            throw new AssertionError();
        }
        String text = this.jsonDataTypeValue.textValue();
        if (text.equals("now")) {
            throw new RuntimeException("TODO: Support 'now' as a value for dates.");
        }
        if (text.equals("infinity")) {
            throw new RuntimeException("TODO: Support 'infinity' as a value for dates.");
        }
        try {
            this.result = Instant.parse(text);
        }
        catch (DateTimeParseException e) {
            throw new AssertionError((Object)e);
        }
    }
}

