/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.deserializer.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import cool.klass.deserializer.json.JsonDataTypeValueVisitor;
import cool.klass.deserializer.json.OperationMode;
import cool.klass.deserializer.json.context.ContextNode;
import cool.klass.deserializer.json.context.ContextStack;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.Multiplicity;
import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.PrimitiveType;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.OrderedMap;
import org.eclipse.collections.api.tuple.Pair;

public class RequiredPropertiesValidator {
    @Nonnull
    protected final ContextStack contextStack;
    @Nonnull
    protected final Klass klass;
    @Nonnull
    protected final ObjectNode objectNode;
    @Nonnull
    protected final OperationMode operationMode;
    @Nonnull
    protected final Optional<AssociationEnd> pathHere;
    protected final boolean isRoot;
    protected final boolean isInProjection;

    public RequiredPropertiesValidator(@Nonnull ContextStack contextStack, @Nonnull Klass klass, @Nonnull ObjectNode objectNode, @Nonnull OperationMode operationMode, @Nonnull Optional<AssociationEnd> pathHere, boolean isRoot, boolean isInProjection) {
        this.contextStack = Objects.requireNonNull(contextStack);
        this.klass = Objects.requireNonNull(klass);
        this.objectNode = Objects.requireNonNull(objectNode);
        this.operationMode = Objects.requireNonNull(operationMode);
        this.pathHere = Objects.requireNonNull(pathHere);
        this.isRoot = isRoot;
        this.isInProjection = isInProjection;
    }

    public static void validate(@Nonnull MutableList<String> errors, @Nonnull MutableList<String> warnings, @Nonnull Klass klass, @Nonnull ObjectNode objectNode, @Nonnull OperationMode operationMode) {
        RequiredPropertiesValidator validator = new RequiredPropertiesValidator(new ContextStack(errors, warnings), klass, objectNode, operationMode, Optional.empty(), true, true);
        validator.validate();
    }

    public void validate() {
        if (this.isRoot) {
            ContextNode contextNode = new ContextNode((NamedElement)this.klass);
            this.contextStack.runWithContext(contextNode, () -> {
                this.handleDataTypeProperties();
                this.handleAssociationEnds();
            });
        } else {
            this.handleDataTypeProperties();
            this.handleAssociationEnds();
        }
    }

    protected void handleDataTypeProperties() {
        ImmutableList dataTypeProperties = this.klass.getDataTypeProperties();
        for (DataTypeProperty dataTypeProperty : dataTypeProperties) {
            ContextNode contextNode = new ContextNode((NamedElement)dataTypeProperty);
            this.contextStack.runWithContext(contextNode, () -> this.handleDataTypeProperty(dataTypeProperty));
        }
    }

    protected void handleDataTypeProperty(@Nonnull DataTypeProperty dataTypeProperty) {
        if (dataTypeProperty.isID()) {
            this.handleIdProperty(dataTypeProperty);
        } else if (dataTypeProperty.isKey()) {
            this.handleKeyProperty(dataTypeProperty);
        } else if (dataTypeProperty.isCreatedBy() || dataTypeProperty.isLastUpdatedBy()) {
            Severity severity = dataTypeProperty.isPrivate() ? Severity.ERROR : Severity.WARNING;
            this.handleIfPresent(dataTypeProperty, "audit", severity);
        } else if (dataTypeProperty.isCreatedOn()) {
            this.handleCreatedOnProperty(dataTypeProperty);
        } else if (dataTypeProperty.isForeignKey()) {
            Severity severity = dataTypeProperty.isPrivate() ? Severity.ERROR : Severity.WARNING;
            this.handleIfPresent(dataTypeProperty, "foreign key", severity);
        } else if (dataTypeProperty.isDerived()) {
            this.handleIfPresent(dataTypeProperty, "derived", Severity.WARNING);
        } else if (dataTypeProperty.getType() == PrimitiveType.TEMPORAL_RANGE) {
            this.handleIfPresent(dataTypeProperty, "temporal range", Severity.ERROR);
        } else if (dataTypeProperty.getType() == PrimitiveType.TEMPORAL_INSTANT && this.isInProjection) {
            if (this.operationMode == OperationMode.CREATE && this.isInProjection) {
                this.handleIfPresent(dataTypeProperty, "temporal", Severity.WARNING);
            }
        } else if (dataTypeProperty.isPrivate()) {
            this.handleIfPresent(dataTypeProperty, "private", Severity.ERROR);
        } else if (dataTypeProperty.isDerived()) {
            this.handleIfPresent(dataTypeProperty, "derived", Severity.WARNING);
        } else if (dataTypeProperty.isVersion()) {
            this.handleVersionProperty(dataTypeProperty);
        } else if (dataTypeProperty.isPrivate()) {
            this.handleIfPresent(dataTypeProperty, "private", Severity.ERROR);
        } else {
            this.handlePlainProperty(dataTypeProperty);
        }
    }

    protected void handleIdProperty(@Nonnull DataTypeProperty dataTypeProperty) {
        JsonNode jsonNode;
        if (this.operationMode == OperationMode.CREATE) {
            return;
        }
        if (this.operationMode == OperationMode.REPLACE && this.isRoot) {
            return;
        }
        if (this.pathHere.isPresent() && this.pathHere.get().getMultiplicity() == Multiplicity.ONE_TO_ONE && ((jsonNode = this.objectNode.path(dataTypeProperty.getName())).isMissingNode() || jsonNode.isNull())) {
            String error = String.format("Expected value for required id property '%s.%s: %s%s' but value was %s.", dataTypeProperty.getOwningClassifier().getName(), dataTypeProperty.getName(), dataTypeProperty.getType(), dataTypeProperty.isOptional() ? "?" : "", jsonNode.getNodeType().toString().toLowerCase());
            this.contextStack.addError(error);
        }
    }

    protected void handleKeyProperty(@Nonnull DataTypeProperty dataTypeProperty) {
        if (this.isForeignKeyMatchingKeyOnPath(dataTypeProperty)) {
            this.handleIfPresent(dataTypeProperty, "foreign key matching key on path", Severity.WARNING);
            return;
        }
        if (this.isForeignKeyMatchingRequiredNested(dataTypeProperty)) {
            this.handleIfPresent(dataTypeProperty, "foreign key matching key of required nested object", Severity.WARNING);
            return;
        }
        if (this.isRoot) {
            this.handleIfPresent(dataTypeProperty, "root key", Severity.WARNING);
            return;
        }
        if (dataTypeProperty.isForeignKeyWithOpposite()) {
            this.handleIfPresent(dataTypeProperty, "foreign key", Severity.WARNING);
            return;
        }
        if (this.pathHere.isPresent() && dataTypeProperty.isForeignKeyMatchingKeyOnPath(this.pathHere.get())) {
            this.handleIfPresent(this.pathHere.get(), dataTypeProperty.getName());
            return;
        }
        if (this.operationMode == OperationMode.PATCH) {
            return;
        }
        JsonNode jsonNode = this.objectNode.path(dataTypeProperty.getName());
        if (jsonNode.isMissingNode() || jsonNode.isNull()) {
            String error = String.format("Expected value for key property '%s.%s: %s%s' but value was %s.", dataTypeProperty.getOwningClassifier().getName(), dataTypeProperty.getName(), dataTypeProperty.getType(), dataTypeProperty.isOptional() ? "?" : "", jsonNode.getNodeType().toString().toLowerCase());
            this.contextStack.addError(error);
        }
    }

    protected boolean isForeignKeyMatchingRequiredNested(DataTypeProperty dataTypeProperty) {
        return dataTypeProperty.getKeysMatchingThisForeignKey().keysView().anySatisfy(this::isToOneRequired);
    }

    private void handleCreatedOnProperty(@Nonnull DataTypeProperty dataTypeProperty) {
        if (this.isInProjection && this.operationMode == OperationMode.CREATE) {
            this.handleIfPresent(dataTypeProperty, "audit", Severity.WARNING);
        } else if ((!this.isInProjection || this.operationMode != OperationMode.REPLACE && this.operationMode != OperationMode.PATCH) && this.isInProjection) {
            throw new AssertionError();
        }
    }

    protected boolean isToOneRequired(AssociationEnd associationEnd) {
        Multiplicity multiplicity = associationEnd.getMultiplicity();
        return multiplicity.isToOne() && multiplicity.isRequired();
    }

    protected boolean isForeignKeyMatchingKeyOnPath(DataTypeProperty dataTypeProperty) {
        return this.pathHere.map(arg_0 -> ((DataTypeProperty)dataTypeProperty).isForeignKeyMatchingKeyOnPath(arg_0)).orElse(false);
    }

    protected void handleIfPresent(@Nonnull DataTypeProperty property, String propertyKind, Severity severity) {
        JsonNode jsonNode = this.objectNode.path(property.getName());
        if (jsonNode.isMissingNode()) {
            return;
        }
        Object jsonNodeString = jsonNode.isNull() ? "" : ": " + jsonNode;
        String annotation = String.format("Didn't expect to receive value for %s property '%s.%s: %s%s' but value was %s%s.", propertyKind, property.getOwningClassifier().getName(), property.getName(), property.getType(), property.isOptional() ? "?" : "", jsonNode.getNodeType().toString().toLowerCase(), jsonNodeString);
        switch (severity) {
            case ERROR: {
                this.contextStack.addError(annotation);
                break;
            }
            case WARNING: {
                this.contextStack.addWarning(annotation);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected value: " + severity));
            }
        }
    }

    protected void handleIfPresent(@Nonnull AssociationEnd property, String propertyKind) {
        JsonNode jsonNode = this.objectNode.path(property.getName());
        if (jsonNode.isMissingNode()) {
            return;
        }
        Object jsonNodeString = jsonNode.isNull() ? "" : ": " + jsonNode;
        String warning = String.format("Didn't expect to receive value for %s association end '%s.%s: %s[%s]' but value was %s%s.", propertyKind, property.getOwningClassifier().getName(), property.getName(), property.getType(), property.getMultiplicity().getPrettyName(), jsonNode.getNodeType().toString().toLowerCase(), jsonNodeString);
        this.contextStack.addWarning(warning);
    }

    protected void handlePlainProperty(@Nonnull DataTypeProperty property) {
        if (!property.isRequired()) {
            return;
        }
        if (!this.isInProjection) {
            this.handleIfPresent(property, "outside projection", Severity.WARNING);
            return;
        }
        if (this.operationMode == OperationMode.PATCH) {
            return;
        }
        JsonNode jsonNode = this.objectNode.path(property.getName());
        if (jsonNode.isMissingNode() || jsonNode.isNull()) {
            String error = String.format("Expected value for required property '%s.%s: %s%s' but value was %s.", property.getOwningClassifier().getName(), property.getName(), property.getType(), property.isOptional() ? "?" : "", jsonNode.getNodeType().toString().toLowerCase());
            this.contextStack.addError(error);
        }
    }

    private void handleVersionProperty(DataTypeProperty property) {
        JsonNode jsonNode = this.objectNode.path(property.getName());
        if (jsonNode.isMissingNode() || jsonNode.isNull()) {
            return;
        }
        if (!jsonNode.isIntegralNumber()) {
            return;
        }
        if (jsonNode.asInt() != 1) {
            String error = String.format("Expected value for version property '%s.%s: %s%s' to be 1 during initial creation but value was %s.", property.getOwningClassifier().getName(), property.getName(), property.getType(), property.isOptional() ? "?" : "", jsonNode.getNodeType().toString().toLowerCase());
            this.contextStack.addError(error);
        }
    }

    protected void handleAssociationEnds() {
        for (AssociationEnd associationEnd : this.klass.getAssociationEnds()) {
            this.handleAssociationEnd(associationEnd);
        }
    }

    protected void handleAssociationEnd(AssociationEnd associationEnd) {
        if (this.isBackward(associationEnd)) {
            this.handleIfPresent(associationEnd, "opposite");
        } else if (associationEnd.isVersion()) {
            this.handleVersionAssociationEnd(associationEnd);
        } else if (associationEnd.isCreatedBy() || associationEnd.isLastUpdatedBy()) {
            this.handleAuditAssociationEnd(associationEnd);
        } else if (associationEnd.isOwned()) {
            this.handleOwnedAssociationEnd(associationEnd);
        } else {
            this.handleAssociationEndOutsideProjection(associationEnd);
        }
    }

    public void handleToOne(@Nonnull AssociationEnd associationEnd, JsonNode jsonNode) {
        ContextNode contextNode = new ContextNode((NamedElement)associationEnd);
        this.contextStack.runWithContext(contextNode, () -> {
            if (jsonNode instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)jsonNode;
                this.handleOwnedAssociationEnd(associationEnd, objectNode);
            }
        });
    }

    public void handleToMany(@Nonnull AssociationEnd associationEnd, JsonNode jsonNode) {
        if (!(jsonNode instanceof ArrayNode)) {
            return;
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode;
        int index = 0;
        while (index < jsonNode.size()) {
            ContextNode contextNode = new ContextNode((NamedElement)associationEnd, index);
            int finalIndex = index++;
            this.contextStack.runWithContext(contextNode, () -> {
                JsonNode childJsonNode = jsonNode.path(finalIndex);
                if (childJsonNode instanceof ObjectNode) {
                    ObjectNode objectNode = (ObjectNode)childJsonNode;
                    this.handleOwnedAssociationEnd(associationEnd, objectNode);
                }
            });
        }
    }

    protected void handleAssociationEndOutsideProjection(AssociationEnd associationEnd) {
        Multiplicity multiplicity = associationEnd.getMultiplicity();
        JsonNode jsonNode = this.objectNode.path(associationEnd.getName());
        if ((jsonNode.isMissingNode() || jsonNode.isNull()) && multiplicity.isRequired()) {
            if (this.operationMode == OperationMode.CREATE && associationEnd.isVersion()) {
                return;
            }
            if (this.operationMode == OperationMode.REPLACE && associationEnd.isFinal()) {
                String warning = String.format("Expected value for required final property '%s.%s: %s[%s]' but value was %s.", associationEnd.getOwningClassifier().getName(), associationEnd.getName(), associationEnd.getType(), associationEnd.getMultiplicity().getPrettyName(), jsonNode.getNodeType().toString().toLowerCase());
                this.contextStack.addWarning(warning);
                return;
            }
            if (this.operationMode == OperationMode.REPLACE && associationEnd.isPrivate()) {
                String warning = String.format("Expected value for required private property '%s.%s: %s[%s]' but value was %s.", associationEnd.getOwningClassifier().getName(), associationEnd.getName(), associationEnd.getType(), associationEnd.getMultiplicity().getPrettyName(), jsonNode.getNodeType().toString().toLowerCase());
                this.contextStack.addWarning(warning);
                return;
            }
            if (this.operationMode == OperationMode.CREATE || this.operationMode == OperationMode.REPLACE || this.operationMode == OperationMode.PATCH && jsonNode.isNull()) {
                String error = String.format("Expected value for required property '%s.%s: %s[%s]' but value was %s.", associationEnd.getOwningClassifier().getName(), associationEnd.getName(), associationEnd.getType(), associationEnd.getMultiplicity().getPrettyName(), jsonNode.getNodeType().toString().toLowerCase());
                this.contextStack.addError(error);
                return;
            }
        }
        if (multiplicity.isToOne()) {
            this.handleToOneOutsideProjection(associationEnd, jsonNode);
        } else {
            this.handleToManyOutsideProjection(associationEnd, jsonNode);
        }
    }

    protected void handleToOneOutsideProjection(@Nonnull AssociationEnd associationEnd, @Nonnull JsonNode jsonNode) {
        if (associationEnd.isOwned()) {
            throw new AssertionError((Object)"Assumption is that all owned association ends are inside projection, all unowned are outside projection");
        }
        if (jsonNode.isMissingNode() || jsonNode.isNull()) {
            if (associationEnd.isRequired() && this.operationMode != OperationMode.PATCH) {
                String error = String.format("Expected value for required property '%s.%s: %s[%s]' but value was %s.", associationEnd.getOwningClassifier().getName(), associationEnd.getName(), associationEnd.getType(), associationEnd.getMultiplicity().getPrettyName(), jsonNode.getNodeType().toString().toLowerCase());
                this.contextStack.addError(error);
            }
            return;
        }
        if (!associationEnd.hasRealKeys()) {
            String warning = String.format("Did not expect value for property '%s.%s: %s[%s]' because it's outside the owned projection and it has no keys other than foreign keys.", associationEnd.getOwningClassifier().getName(), associationEnd.getName(), associationEnd.getType(), associationEnd.getMultiplicity().getPrettyName());
            this.contextStack.addWarning(warning);
        }
        ContextNode contextNode = new ContextNode((NamedElement)associationEnd);
        this.contextStack.runWithContext(contextNode, () -> {
            if (!(jsonNode instanceof ObjectNode)) {
                return;
            }
            ObjectNode objectNode = (ObjectNode)jsonNode;
            OperationMode nextMode = this.getNextMode(this.operationMode, associationEnd);
            RequiredPropertiesValidator validator = new RequiredPropertiesValidator(this.contextStack, associationEnd.getType(), objectNode, nextMode, Optional.of(associationEnd), false, false);
            validator.validate();
        });
    }

    protected void handleToManyOutsideProjection(@Nonnull AssociationEnd associationEnd, @Nonnull JsonNode jsonNode) {
        if (associationEnd.isOwned()) {
            throw new AssertionError((Object)"Assumption is that all owned association ends are inside projection, all unowned are outside projection");
        }
        if (jsonNode.isMissingNode() || jsonNode.isNull()) {
            if (associationEnd.isRequired()) {
                String error = String.format("Expected value for required property '%s.%s: %s[%s]' but value was %s.", associationEnd.getOwningClassifier().getName(), associationEnd.getName(), associationEnd.getType(), associationEnd.getMultiplicity().getPrettyName(), jsonNode.getNodeType().toString().toLowerCase());
                this.contextStack.addError(error);
            }
            return;
        }
        if (!associationEnd.hasRealKeys()) {
            String warning = String.format("Did not expect value for property '%s.%s: %s[%s]' because it's outside the owned projection and it has no keys other than foreign keys.", associationEnd.getOwningClassifier().getName(), associationEnd.getName(), associationEnd.getType(), associationEnd.getMultiplicity().getPrettyName());
            this.contextStack.addWarning(warning);
        }
        if (!(jsonNode instanceof ArrayNode)) {
            return;
        }
        int index = 0;
        while (index < jsonNode.size()) {
            int finalIndex = index++;
            ContextNode contextNode = new ContextNode((NamedElement)associationEnd, finalIndex);
            this.contextStack.runWithContext(contextNode, () -> {
                JsonNode childJsonNode = jsonNode.path(finalIndex);
                if (!(childJsonNode instanceof ObjectNode)) {
                    return;
                }
                OperationMode nextMode = this.getNextMode(this.operationMode, associationEnd);
                RequiredPropertiesValidator validator = new RequiredPropertiesValidator(this.contextStack, associationEnd.getType(), (ObjectNode)childJsonNode, nextMode, Optional.of(associationEnd), false, false);
                validator.validate();
            });
        }
    }

    protected void handleErrorIfAbsent(@Nonnull AssociationEnd associationEnd, String propertyKind) {
        JsonNode jsonNode = this.objectNode.path(associationEnd.getName());
        if (!jsonNode.isMissingNode() && !jsonNode.isNull()) {
            return;
        }
        String error = String.format("Expected value for %s property '%s.%s: %s[%s]' but value was %s.", propertyKind, associationEnd.getOwningClassifier().getName(), associationEnd.getName(), associationEnd.getType(), associationEnd.getMultiplicity().getPrettyName(), jsonNode.getNodeType().toString().toLowerCase());
        this.contextStack.addError(error);
    }

    protected void handleOwnedAssociationEnd(@Nonnull AssociationEnd associationEnd, @Nonnull ObjectNode objectNode) {
        OperationMode nextMode = this.getNextMode(this.operationMode, associationEnd);
        if (associationEnd.isVersion()) {
            this.handleVersionAssociationEnd(associationEnd);
        } else {
            this.handlePlainAssociationEnd(associationEnd, objectNode, nextMode);
        }
    }

    protected void handleOwnedAssociationEnd(@Nonnull AssociationEnd associationEnd) {
        Multiplicity multiplicity = associationEnd.getMultiplicity();
        JsonNode jsonNode = this.objectNode.path(associationEnd.getName());
        if ((jsonNode.isMissingNode() || jsonNode.isNull()) && multiplicity.isRequired()) {
            if (this.operationMode == OperationMode.CREATE && associationEnd.isVersion()) {
                return;
            }
            if (this.operationMode == OperationMode.REPLACE && associationEnd.isFinal()) {
                String warning = String.format("Expected value for required final property '%s.%s: %s[%s]' but value was %s.", associationEnd.getOwningClassifier().getName(), associationEnd.getName(), associationEnd.getType(), associationEnd.getMultiplicity().getPrettyName(), jsonNode.getNodeType().toString().toLowerCase());
                this.contextStack.addWarning(warning);
                return;
            }
            if (this.operationMode == OperationMode.REPLACE && associationEnd.isPrivate()) {
                String warning = String.format("Expected value for required private property '%s.%s: %s[%s]' but value was %s.", associationEnd.getOwningClassifier().getName(), associationEnd.getName(), associationEnd.getType(), associationEnd.getMultiplicity().getPrettyName(), jsonNode.getNodeType().toString().toLowerCase());
                this.contextStack.addWarning(warning);
                return;
            }
            if (this.operationMode == OperationMode.CREATE || this.operationMode == OperationMode.REPLACE || this.operationMode == OperationMode.PATCH && jsonNode.isNull()) {
                String error = String.format("Expected value for required property '%s.%s: %s[%s]' but value was %s.", associationEnd.getOwningClassifier().getName(), associationEnd.getName(), associationEnd.getType(), associationEnd.getMultiplicity().getPrettyName(), jsonNode.getNodeType().toString().toLowerCase());
                this.contextStack.addError(error);
                return;
            }
        }
        if (multiplicity.isToOne()) {
            this.handleToOne(associationEnd, jsonNode);
        } else {
            this.handleToMany(associationEnd, jsonNode);
        }
    }

    protected void handleVersionAssociationEnd(@Nonnull AssociationEnd associationEnd) {
        JsonNode jsonNode = this.objectNode.path(associationEnd.getName());
        if (this.operationMode == OperationMode.CREATE) {
            if (jsonNode.isMissingNode()) {
                return;
            }
            ContextNode contextNode = new ContextNode((NamedElement)associationEnd);
            this.contextStack.runWithContext(contextNode, () -> {
                if (jsonNode instanceof ObjectNode) {
                    ObjectNode objectNode = (ObjectNode)jsonNode;
                    OperationMode nextMode = this.getNextMode(this.operationMode, associationEnd);
                    RequiredPropertiesValidator validator = new RequiredPropertiesValidator(this.contextStack, associationEnd.getType(), objectNode, nextMode, Optional.of(associationEnd), false, this.isInProjection && associationEnd.isOwned());
                    validator.validate();
                }
            });
        } else if (this.operationMode == OperationMode.REPLACE || this.operationMode == OperationMode.PATCH) {
            if (this.klass.getKeyProperties().anySatisfy(DataTypeProperty::isID)) {
                this.handleErrorIfAbsent(associationEnd, "version");
            }
        } else if (this.operationMode == OperationMode.REFERENCE_OUTSIDE_PROJECTION) {
            this.handleIfPresent(associationEnd, "version");
        } else {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".handleVersionAssociationEnd() not implemented yet");
        }
    }

    protected void handleAuditAssociationEnd(@Nonnull AssociationEnd associationEnd) {
        JsonNode jsonNode = this.objectNode.path(associationEnd.getName());
        if (jsonNode.isMissingNode()) {
            return;
        }
        this.handleAssociationEndOutsideProjection(associationEnd);
    }

    protected void handlePlainAssociationEnd(@Nonnull AssociationEnd associationEnd, @Nonnull ObjectNode objectNode, @Nonnull OperationMode nextMode) {
        RequiredPropertiesValidator validator = new RequiredPropertiesValidator(this.contextStack, associationEnd.getType(), objectNode, nextMode, Optional.of(associationEnd), false, this.isInProjection && associationEnd.isOwned());
        validator.validate();
    }

    @Nonnull
    protected OperationMode getNextMode(OperationMode operationMode, @Nonnull AssociationEnd associationEnd) {
        if (operationMode == OperationMode.CREATE && associationEnd.isOwned()) {
            return OperationMode.CREATE;
        }
        if (operationMode == OperationMode.REPLACE && associationEnd.isOwned()) {
            return OperationMode.REPLACE;
        }
        if (operationMode == OperationMode.PATCH && associationEnd.isOwned()) {
            return OperationMode.PATCH;
        }
        if (!(operationMode != OperationMode.CREATE && operationMode != OperationMode.PATCH && operationMode != OperationMode.REPLACE || associationEnd.isOwned())) {
            return OperationMode.REFERENCE_OUTSIDE_PROJECTION;
        }
        if (operationMode == OperationMode.REFERENCE_OUTSIDE_PROJECTION) {
            return OperationMode.REFERENCE_OUTSIDE_PROJECTION;
        }
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getNextMode() not implemented yet: " + operationMode);
    }

    protected ImmutableList<Object> getKeysFromJsonNode(@Nonnull JsonNode jsonNode, @Nonnull AssociationEnd associationEnd, @Nonnull JsonNode parentJsonNode) {
        Klass type = associationEnd.getType();
        ImmutableList keyProperties = type.getKeyProperties();
        ImmutableList nonForeignKeyProperties = keyProperties.reject(DataTypeProperty::isForeignKey);
        return nonForeignKeyProperties.collect((Function & Serializable)keyProperty -> this.getKeyFromJsonNode((DataTypeProperty)keyProperty, jsonNode, associationEnd, parentJsonNode));
    }

    protected Object getKeyFromJsonNode(@Nonnull DataTypeProperty keyProperty, @Nonnull JsonNode jsonNode, @Nonnull AssociationEnd associationEnd, @Nonnull JsonNode parentJsonNode) {
        AssociationEnd opposite;
        OrderedMap keysMatchingThisForeignKey = keyProperty.getKeysMatchingThisForeignKey();
        DataTypeProperty oppositeForeignKey = (DataTypeProperty)keysMatchingThisForeignKey.get((Object)(opposite = associationEnd.getOpposite()));
        if (oppositeForeignKey != null) {
            String oppositeForeignKeyName = oppositeForeignKey.getName();
            JsonNode result = parentJsonNode.path(oppositeForeignKeyName);
            return Objects.requireNonNull(result);
        }
        if (keysMatchingThisForeignKey.notEmpty()) {
            if (keysMatchingThisForeignKey.size() != 1) {
                throw new AssertionError();
            }
            Pair pair = (Pair)keysMatchingThisForeignKey.keyValuesView().getOnly();
            JsonNode childNode = jsonNode.path(((AssociationEnd)pair.getOne()).getName());
            Object result = JsonDataTypeValueVisitor.extractDataTypePropertyFromJson((DataTypeProperty)pair.getTwo(), (ObjectNode)childNode);
            return Objects.requireNonNull(result);
        }
        Object result = JsonDataTypeValueVisitor.extractDataTypePropertyFromJson(keyProperty, (ObjectNode)jsonNode);
        return Objects.requireNonNull(result);
    }

    protected boolean isBackward(@Nonnull AssociationEnd associationEnd) {
        return this.pathHere.equals(Optional.of(associationEnd.getOpposite()));
    }

    private static enum Severity {
        ERROR,
        WARNING;

    }
}

