/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.deserializer.json.context;

import cool.klass.deserializer.json.context.ContextNode;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.collections.api.factory.Stacks;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.stack.MutableStack;

public class ContextStack {
    @Nonnull
    private final MutableStack<ContextNode> delegate = Stacks.mutable.empty();
    @Nonnull
    private final MutableList<String> errors;
    @Nullable
    private final MutableList<String> warnings;

    public ContextStack(@Nonnull MutableList<String> errors, @Nullable MutableList<String> warnings) {
        this.errors = Objects.requireNonNull(errors);
        this.warnings = warnings;
    }

    public void push(@Nonnull ContextNode contextNode) {
        Objects.requireNonNull(contextNode);
        this.delegate.push((Object)contextNode);
    }

    public void pop() {
        this.delegate.pop();
    }

    public void runWithContext(@Nonnull ContextNode contextNode, @Nonnull Runnable runnable) {
        Objects.requireNonNull(contextNode);
        Objects.requireNonNull(runnable);
        this.delegate.push((Object)contextNode);
        try {
            runnable.run();
        }
        finally {
            this.delegate.pop();
        }
    }

    public void addError(String message) {
        String error = String.format("Error at %s. %s", this, message);
        this.errors.add((Object)error);
    }

    public void addWarning(String message) {
        String warning = String.format("Warning at %s. %s", this, message);
        this.warnings.add((Object)warning);
    }

    public String toString() {
        return this.delegate.toList().asReversed().makeString(".");
    }
}

