/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.deserializer.json.type;

import com.fasterxml.jackson.databind.JsonNode;
import cool.klass.deserializer.json.context.ContextNode;
import cool.klass.deserializer.json.context.ContextStack;
import cool.klass.deserializer.json.type.ArrayNodeTypeCheckingValidator;
import cool.klass.deserializer.json.type.JsonTypeCheckingPrimitiveTypeVisitor;
import cool.klass.deserializer.json.type.ObjectNodeTypeCheckingValidator;
import cool.klass.model.meta.domain.api.Enumeration;
import cool.klass.model.meta.domain.api.EnumerationLiteral;
import cool.klass.model.meta.domain.api.Multiplicity;
import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.PrimitiveType;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.AssociationEndSignature;
import cool.klass.model.meta.domain.api.property.EnumerationProperty;
import cool.klass.model.meta.domain.api.property.ParameterizedProperty;
import cool.klass.model.meta.domain.api.property.PrimitiveProperty;
import cool.klass.model.meta.domain.api.property.Property;
import cool.klass.model.meta.domain.api.property.PropertyVisitor;
import cool.klass.model.meta.domain.api.visitor.PrimitiveTypeVisitor;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.list.ImmutableList;

public record JsonTypeCheckingPropertyVisitor(@Nonnull ContextStack contextStack, Property property, JsonNode childJsonNode) implements PropertyVisitor
{
    public JsonTypeCheckingPropertyVisitor(@Nonnull ContextStack contextStack, @Nonnull Property property, @Nonnull JsonNode childJsonNode) {
        this.contextStack = Objects.requireNonNull(contextStack);
        this.property = Objects.requireNonNull(property);
        this.childJsonNode = Objects.requireNonNull(childJsonNode);
    }

    private void visitPropertyWithContext(@Nonnull Runnable runnable) {
        this.contextStack.push(new ContextNode((NamedElement)this.property));
        try {
            runnable.run();
        }
        finally {
            this.contextStack.pop();
        }
    }

    public void visitPrimitiveProperty(@Nonnull PrimitiveProperty primitiveProperty) {
        this.visitPropertyWithContext(() -> this.handlePrimitiveProperty(primitiveProperty));
    }

    public void handlePrimitiveProperty(@Nonnull PrimitiveProperty primitiveProperty) {
        PrimitiveType primitiveType = primitiveProperty.getType();
        JsonTypeCheckingPrimitiveTypeVisitor visitor = new JsonTypeCheckingPrimitiveTypeVisitor(this.contextStack, primitiveProperty, this.childJsonNode);
        primitiveType.visit((PrimitiveTypeVisitor)visitor);
    }

    public void visitEnumerationProperty(@Nonnull EnumerationProperty enumerationProperty) {
        this.visitPropertyWithContext(() -> this.handleEnumerationProperty(enumerationProperty));
    }

    public void handleEnumerationProperty(@Nonnull EnumerationProperty enumerationProperty) {
        if (!this.childJsonNode.isTextual()) {
            String error = String.format("Expected enumerated property with type '%s.%s: %s%s' but got %s with type '%s'.", this.contextStack, enumerationProperty.getOwningClassifier().getName(), enumerationProperty.getName(), enumerationProperty.getType().getName(), enumerationProperty.isOptional() ? "?" : "", this.childJsonNode, this.childJsonNode.getNodeType().toString().toLowerCase());
            this.contextStack.addError(error);
        }
        String textValue = this.childJsonNode.textValue();
        Enumeration enumeration = enumerationProperty.getType();
        ImmutableList enumerationLiterals = enumeration.getEnumerationLiterals();
        if (!enumerationLiterals.asLazy().collect(EnumerationLiteral::getPrettyName).contains((Object)textValue)) {
            ImmutableList quotedPrettyNames = enumerationLiterals.collect(EnumerationLiteral::getPrettyName).collect((Function & Serializable)each -> "\"" + each + "\"");
            String error = String.format("Expected enumerated property with type '%s.%s: %s%s' but got %s with type '%s'. Expected one of %s.", enumerationProperty.getOwningClassifier().getName(), enumerationProperty.getName(), enumerationProperty.getType().getName(), enumerationProperty.isOptional() ? "?" : "", this.childJsonNode, this.childJsonNode.getNodeType().toString().toLowerCase(), quotedPrettyNames.makeString());
            this.contextStack.addError(error);
        }
    }

    public void visitAssociationEndSignature(AssociationEndSignature associationEndSignature) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".visitAssociationEndSignature() not implemented yet");
    }

    public void visitAssociationEnd(@Nonnull AssociationEnd associationEnd) {
        Multiplicity multiplicity = associationEnd.getMultiplicity();
        if (multiplicity.isToOne()) {
            ContextNode contextNode = new ContextNode((NamedElement)associationEnd);
            this.contextStack.runWithContext(contextNode, () -> {
                ObjectNodeTypeCheckingValidator validator = new ObjectNodeTypeCheckingValidator(this.contextStack, associationEnd.getType(), this.childJsonNode);
                validator.validateIncomingData();
            });
        } else if (multiplicity.isToMany()) {
            ArrayNodeTypeCheckingValidator jsonTypeCheckingValidator = new ArrayNodeTypeCheckingValidator(this.contextStack, (NamedElement)associationEnd, associationEnd.getType(), this.childJsonNode);
            jsonTypeCheckingValidator.validateIncomingData();
        } else {
            throw new AssertionError(multiplicity);
        }
    }

    public void visitParameterizedProperty(ParameterizedProperty parameterizedProperty) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".visitParameterizedProperty() not implemented yet");
    }
}

