/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.deserializer.json.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import cool.klass.deserializer.json.context.ContextNode;
import cool.klass.deserializer.json.context.ContextStack;
import cool.klass.deserializer.json.type.JsonTypeCheckingPropertyVisitor;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.property.Property;
import cool.klass.model.meta.domain.api.property.PropertyVisitor;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.list.MutableList;

public final class ObjectNodeTypeCheckingValidator {
    @Nonnull
    private final ContextStack contextStack;
    @Nonnull
    private final Klass klass;
    @Nonnull
    private final JsonNode jsonNode;

    public ObjectNodeTypeCheckingValidator(@Nonnull ContextStack contextStack, @Nonnull Klass klass, @Nonnull JsonNode jsonNode) {
        this.contextStack = Objects.requireNonNull(contextStack);
        this.klass = Objects.requireNonNull(klass);
        this.jsonNode = Objects.requireNonNull(jsonNode);
    }

    public static void validate(@Nonnull MutableList<String> errors, @Nonnull JsonNode jsonNode, @Nonnull Klass klass) {
        ContextStack contextStack = new ContextStack(errors, null);
        ContextNode contextNode = new ContextNode((NamedElement)klass);
        contextStack.runWithContext(contextNode, () -> {
            ObjectNodeTypeCheckingValidator validator = new ObjectNodeTypeCheckingValidator(contextStack, klass, jsonNode);
            validator.validateIncomingData();
        });
    }

    public void validateIncomingData() {
        JsonNode jsonNode = this.jsonNode;
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            this.validateObjectNode(objectNode);
        } else {
            String error = String.format("Expected json object but value was %s: %s.", this.jsonNode.getNodeType().toString().toLowerCase(), this.jsonNode);
            this.contextStack.addError(error);
        }
    }

    private void validateObjectNode(@Nonnull ObjectNode objectNode) {
        objectNode.fields().forEachRemaining(entry -> {
            String childFieldName = (String)entry.getKey();
            JsonNode childJsonNode = (JsonNode)entry.getValue();
            Optional optionalProperty = this.klass.getPropertyByName(childFieldName);
            if (optionalProperty.isEmpty()) {
                this.handleMissingProperty(childFieldName, childJsonNode);
                return;
            }
            if (childJsonNode.isNull()) {
                return;
            }
            Property property = (Property)optionalProperty.get();
            JsonTypeCheckingPropertyVisitor visitor = new JsonTypeCheckingPropertyVisitor(this.contextStack, property, childJsonNode);
            property.visit((PropertyVisitor)visitor);
        });
    }

    private void handleMissingProperty(String childFieldName, JsonNode childJsonNode) {
        String error = String.format("No such property '%s.%s' but got %s. Expected properties: %s.", this.klass, childFieldName, childJsonNode, this.klass.getProperties().reject(Property::isPrivate).collect(NamedElement::getName).makeString());
        this.contextStack.addError(error);
    }
}

