/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.deserializer.json.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import cool.klass.deserializer.json.context.ContextNode;
import cool.klass.deserializer.json.context.ContextStack;
import cool.klass.deserializer.json.type.ObjectNodeTypeCheckingValidator;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.NamedElement;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.list.MutableList;

public final class ArrayNodeTypeCheckingValidator {
    @Nonnull
    private final ContextStack contextStack;
    @Nonnull
    private final NamedElement context;
    @Nonnull
    private final Klass klass;
    @Nonnull
    private final JsonNode jsonNode;

    public ArrayNodeTypeCheckingValidator(@Nonnull ContextStack contextStack, @Nonnull NamedElement context, @Nonnull Klass klass, @Nonnull JsonNode jsonNode) {
        this.contextStack = Objects.requireNonNull(contextStack);
        this.context = context;
        this.jsonNode = Objects.requireNonNull(jsonNode);
        this.klass = Objects.requireNonNull(klass);
    }

    public static void validate(@Nonnull MutableList<String> errors, @Nonnull JsonNode jsonNode, @Nonnull Klass klass) {
        ContextStack contextStack = new ContextStack(errors, null);
        ArrayNodeTypeCheckingValidator incomingDataValidator = new ArrayNodeTypeCheckingValidator(contextStack, (NamedElement)klass, klass, jsonNode);
        incomingDataValidator.validateIncomingData();
    }

    public void validateIncomingData() {
        JsonNode jsonNode = this.jsonNode;
        if (!(jsonNode instanceof ArrayNode)) {
            String error = String.format("Expected json array but value was %s: %s.", this.jsonNode.getNodeType().toString().toLowerCase(Locale.ROOT), this.jsonNode);
            this.contextStack.addError(error);
            return;
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode;
        this.validateArrayNode(arrayNode);
    }

    private void validateArrayNode(@Nonnull ArrayNode arrayNode) {
        for (int index = 0; index < arrayNode.size(); ++index) {
            JsonNode childJsonNode = arrayNode.path(index);
            ContextNode contextNode = new ContextNode(this.context, index);
            this.contextStack.runWithContext(contextNode, () -> {
                ObjectNodeTypeCheckingValidator validator = new ObjectNodeTypeCheckingValidator(this.contextStack, this.klass, childJsonNode);
                validator.validateIncomingData();
            });
        }
    }
}

