/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.deserializer.json.type;

import com.fasterxml.jackson.databind.JsonNode;
import cool.klass.deserializer.json.context.ContextStack;
import cool.klass.model.meta.domain.api.modifier.Modifier;
import cool.klass.model.meta.domain.api.property.PrimitiveProperty;
import cool.klass.model.meta.domain.api.visitor.PrimitiveTypeVisitor;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;

public class JsonTypeCheckingPrimitiveTypeVisitor
implements PrimitiveTypeVisitor {
    @Nonnull
    private final ContextStack contextStack;
    @Nonnull
    private final PrimitiveProperty primitiveProperty;
    @Nonnull
    private final JsonNode jsonDataTypeValue;

    public JsonTypeCheckingPrimitiveTypeVisitor(ContextStack contextStack, PrimitiveProperty primitiveProperty, JsonNode jsonDataTypeValue) {
        this.contextStack = Objects.requireNonNull(contextStack);
        this.primitiveProperty = Objects.requireNonNull(primitiveProperty);
        this.jsonDataTypeValue = Objects.requireNonNull(jsonDataTypeValue);
    }

    private void emitTypeError() {
        String error = String.format("Expected property with type '%s.%s: %s%s' but got '%s' with type '%s'.", this.primitiveProperty.getOwningClassifier().getName(), this.primitiveProperty.getName(), this.primitiveProperty.getType().getPrettyName(), this.primitiveProperty.isOptional() ? "?" : "", this.jsonDataTypeValue, this.jsonDataTypeValue.getNodeType().toString().toLowerCase(Locale.ROOT));
        this.contextStack.addError(error);
    }

    public void visitString() {
        if (!this.jsonDataTypeValue.isTextual()) {
            this.emitTypeError();
        }
    }

    public void visitInteger() {
        if (!this.jsonDataTypeValue.isIntegralNumber() || !this.jsonDataTypeValue.canConvertToInt()) {
            this.emitTypeError();
        }
    }

    public void visitLong() {
        if (!this.jsonDataTypeValue.isIntegralNumber() || !this.jsonDataTypeValue.canConvertToLong()) {
            this.emitTypeError();
        }
    }

    public void visitDouble() {
        if (!(this.jsonDataTypeValue.isDouble() || this.jsonDataTypeValue.isFloat() || this.jsonDataTypeValue.isInt() || this.jsonDataTypeValue.isLong())) {
            this.emitTypeError();
        }
    }

    public void visitFloat() {
        if (!((this.jsonDataTypeValue.isDouble() || this.jsonDataTypeValue.isFloat() || this.jsonDataTypeValue.isInt() || this.jsonDataTypeValue.isLong()) && this.hasValidFloatString())) {
            this.emitTypeError();
        }
    }

    private boolean hasValidFloatString() {
        double doubleValue = this.jsonDataTypeValue.doubleValue();
        float floatValue = this.jsonDataTypeValue.floatValue();
        String doubleString = Double.toString(doubleValue);
        String floatString = Float.toString(floatValue);
        return doubleString.equals(floatString);
    }

    public void visitBoolean() {
        if (!this.jsonDataTypeValue.isBoolean()) {
            this.emitTypeError();
        }
    }

    public void visitInstant() {
        this.visitTemporal();
    }

    public void visitLocalDate() {
        if (!this.jsonDataTypeValue.isTextual()) {
            this.emitTypeError();
            return;
        }
        String text = this.jsonDataTypeValue.textValue();
        if (text.equals("now") || text.equals("infinity")) {
            return;
        }
        try {
            LocalDate.parse(text);
        }
        catch (DateTimeParseException e) {
            String error = String.format("Expected property with type '%s' but got '%s' which could not be parsed by LocalDate.parse() which expects a String like '1999-12-31.", this.primitiveProperty, this.jsonDataTypeValue);
            this.contextStack.addError(error);
        }
    }

    public void visitTemporalInstant() {
        this.visitTemporal();
    }

    public void visitTemporalRange() {
        this.visitTemporal();
    }

    private void visitTemporal() {
        if (this.jsonDataTypeValue.isNull() && this.primitiveProperty.isTemporalInstant() && this.primitiveProperty.getModifiers().anySatisfy(Modifier::isTo)) {
            return;
        }
        if (!this.jsonDataTypeValue.isTextual()) {
            this.emitTypeError();
            return;
        }
        String text = this.jsonDataTypeValue.textValue();
        if (text.equals("now") || text.equals("infinity")) {
            return;
        }
        try {
            Instant.parse(text);
        }
        catch (DateTimeParseException e) {
            String error = String.format("Expected property with type '%s' but got '%s' which could not be parsed by java.time.format.DateTimeFormatter.ISO_INSTANT which expects a String like '1999-12-31T23:59:59Z'", this.primitiveProperty, this.jsonDataTypeValue);
            this.contextStack.addError(error);
        }
    }
}

