/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.dropwizard.bundle.test.data;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.service.AutoService;
import cool.klass.data.store.DataStore;
import cool.klass.dropwizard.configuration.data.store.DataStoreFactoryProvider;
import cool.klass.dropwizard.configuration.domain.model.loader.DomainModelFactoryProvider;
import cool.klass.dropwizard.configuration.sample.data.SampleDataFactory;
import cool.klass.dropwizard.configuration.sample.data.SampleDataFactoryProvider;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.reladomo.sample.data.SampleDataGenerator;
import io.dropwizard.setup.Environment;
import io.liftwizard.dropwizard.bundle.prioritized.PrioritizedBundle;
import java.time.Instant;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.list.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={PrioritizedBundle.class})
public class SampleDataGeneratorBundle
implements PrioritizedBundle {
    private static final Logger LOGGER = LoggerFactory.getLogger(SampleDataGeneratorBundle.class);

    public int getPriority() {
        return -1;
    }

    public void runWithMdc(@Nonnull Object configuration, @Nonnull Environment environment) {
        SampleDataFactoryProvider sampleDataFactoryProvider = (SampleDataFactoryProvider)this.safeCastConfiguration(SampleDataFactoryProvider.class, configuration);
        DomainModelFactoryProvider domainModelFactoryProvider = (DomainModelFactoryProvider)this.safeCastConfiguration(DomainModelFactoryProvider.class, configuration);
        DataStoreFactoryProvider dataStoreFactoryProvider = (DataStoreFactoryProvider)this.safeCastConfiguration(DataStoreFactoryProvider.class, configuration);
        SampleDataFactory sampleDataFactory = sampleDataFactoryProvider.getSampleDataFactory();
        if (!sampleDataFactory.isEnabled()) {
            LOGGER.info("{} disabled.", (Object)this.getClass().getSimpleName());
            return;
        }
        LOGGER.info("Running {}.", (Object)this.getClass().getSimpleName());
        Instant dataInstant = sampleDataFactory.getDataInstant();
        ImmutableList skippedPackages = sampleDataFactory.getSkippedPackages();
        ObjectMapper objectMapper = environment.getObjectMapper();
        DomainModel domainModel = domainModelFactoryProvider.getDomainModelFactory().createDomainModel(objectMapper);
        DataStore dataStore = dataStoreFactoryProvider.getDataStoreFactory().createDataStore();
        SampleDataGenerator sampleDataGenerator = new SampleDataGenerator(domainModel, dataStore, dataInstant, skippedPackages);
        sampleDataGenerator.generate();
        LOGGER.info("Completing {}.", (Object)this.getClass().getSimpleName());
    }
}

