/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.dropwizard.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import cool.klass.dropwizard.configuration.KlassFactory;
import cool.klass.dropwizard.configuration.data.store.DataStoreFactory;
import cool.klass.dropwizard.configuration.data.store.DataStoreFactoryProvider;
import cool.klass.dropwizard.configuration.domain.model.loader.DomainModelFactory;
import cool.klass.dropwizard.configuration.domain.model.loader.DomainModelFactoryProvider;
import cool.klass.dropwizard.configuration.sample.data.SampleDataFactory;
import cool.klass.dropwizard.configuration.sample.data.SampleDataFactoryProvider;
import io.dropwizard.Configuration;
import io.liftwizard.dropwizard.configuration.auth.filter.AuthFilterFactory;
import io.liftwizard.dropwizard.configuration.auth.filter.AuthFilterFactoryProvider;
import io.liftwizard.dropwizard.configuration.clock.ClockFactory;
import io.liftwizard.dropwizard.configuration.clock.ClockFactoryProvider;
import io.liftwizard.dropwizard.configuration.config.logging.ConfigLoggingFactoryProvider;
import io.liftwizard.dropwizard.configuration.connectionmanager.ConnectionManagerProvider;
import io.liftwizard.dropwizard.configuration.connectionmanager.ConnectionManagersFactory;
import io.liftwizard.dropwizard.configuration.cors.CorsFactory;
import io.liftwizard.dropwizard.configuration.cors.CorsFactoryProvider;
import io.liftwizard.dropwizard.configuration.datasource.NamedDataSourceProvider;
import io.liftwizard.dropwizard.configuration.datasource.NamedDataSourcesFactory;
import io.liftwizard.dropwizard.configuration.ddl.executor.DdlExecutorFactory;
import io.liftwizard.dropwizard.configuration.ddl.executor.DdlExecutorFactoryProvider;
import io.liftwizard.dropwizard.configuration.enabled.EnabledFactory;
import io.liftwizard.dropwizard.configuration.h2.H2Factory;
import io.liftwizard.dropwizard.configuration.h2.H2FactoryProvider;
import io.liftwizard.dropwizard.configuration.http.logging.JerseyHttpLoggingFactory;
import io.liftwizard.dropwizard.configuration.http.logging.JerseyHttpLoggingFactoryProvider;
import io.liftwizard.dropwizard.configuration.liquibase.migration.LiquibaseMigrationFactory;
import io.liftwizard.dropwizard.configuration.liquibase.migration.LiquibaseMigrationFactoryProvider;
import io.liftwizard.dropwizard.configuration.object.mapper.ObjectMapperFactory;
import io.liftwizard.dropwizard.configuration.object.mapper.ObjectMapperFactoryProvider;
import io.liftwizard.dropwizard.configuration.reladomo.ReladomoFactory;
import io.liftwizard.dropwizard.configuration.reladomo.ReladomoFactoryProvider;
import io.liftwizard.dropwizard.configuration.system.properties.SystemPropertiesFactory;
import io.liftwizard.dropwizard.configuration.system.properties.SystemPropertiesFactoryProvider;
import io.liftwizard.dropwizard.configuration.uuid.UUIDSupplierFactory;
import io.liftwizard.dropwizard.configuration.uuid.UUIDSupplierFactoryProvider;
import java.util.Arrays;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"server", "logging", "metrics", "klass", "configLogging", "objectMapper", "cors", "authFilters", "jerseyHttpLogging", "h2", "dataSources", "ddlExecutors", "reladomo", "connectionManagers", "sampleData", "bootstrap"})
public abstract class AbstractKlassConfiguration
extends Configuration
implements ConfigLoggingFactoryProvider,
CorsFactoryProvider,
AuthFilterFactoryProvider,
ObjectMapperFactoryProvider,
JerseyHttpLoggingFactoryProvider,
H2FactoryProvider,
DdlExecutorFactoryProvider,
ReladomoFactoryProvider,
SampleDataFactoryProvider,
DataStoreFactoryProvider,
DomainModelFactoryProvider,
UUIDSupplierFactoryProvider,
ClockFactoryProvider,
NamedDataSourceProvider,
ConnectionManagerProvider,
SystemPropertiesFactoryProvider,
LiquibaseMigrationFactoryProvider {
    @Valid
    private KlassFactory klassFactory;
    @Valid
    @NotNull
    private SystemPropertiesFactory systemPropertiesFactory = new SystemPropertiesFactory();
    @Valid
    @NotNull
    private EnabledFactory configLoggingFactory = new EnabledFactory();
    @Valid
    @NotNull
    private ObjectMapperFactory objectMapperFactory = new ObjectMapperFactory();
    @Valid
    @NotNull
    private CorsFactory corsFactory = new CorsFactory();
    @Valid
    @NotNull
    private List<AuthFilterFactory> authFilterFactories = Arrays.asList(new AuthFilterFactory[0]);
    @Valid
    @NotNull
    private JerseyHttpLoggingFactory jerseyHttpLoggingFactory = new JerseyHttpLoggingFactory();
    @Valid
    private H2Factory h2Factory;
    @Valid
    @NotNull
    private List<DdlExecutorFactory> ddlExecutorFactories = Arrays.asList(new DdlExecutorFactory[0]);
    @Valid
    @NotNull
    private ReladomoFactory reladomoFactory = new ReladomoFactory();
    @Valid
    @NotNull
    private SampleDataFactory sampleDataFactory = new SampleDataFactory();
    @Valid
    @NotNull
    private EnabledFactory bootstrapFactory = new EnabledFactory();
    @Valid
    @NotNull
    private LiquibaseMigrationFactory liquibaseMigrationFactory = new LiquibaseMigrationFactory();
    @JsonUnwrapped
    @Valid
    @NotNull
    private NamedDataSourcesFactory namedDataSourcesFactory = new NamedDataSourcesFactory();
    @JsonUnwrapped
    @Valid
    @NotNull
    private ConnectionManagersFactory connectionManagersFactory = new ConnectionManagersFactory();

    @JsonProperty(value="klass")
    public KlassFactory getKlassFactory() {
        return this.klassFactory;
    }

    @JsonProperty(value="klass")
    public void setKlassFactory(KlassFactory klassFactory) {
        this.klassFactory = klassFactory;
    }

    @JsonProperty(value="configLogging")
    public EnabledFactory getConfigLoggingFactory() {
        return this.configLoggingFactory;
    }

    @JsonProperty(value="configLogging")
    public void setConfigLoggingFactory(EnabledFactory configLoggingFactory) {
        this.configLoggingFactory = configLoggingFactory;
    }

    @JsonProperty(value="objectMapper")
    public ObjectMapperFactory getObjectMapperFactory() {
        return this.objectMapperFactory;
    }

    @JsonProperty(value="objectMapper")
    public void setObjectMapperFactory(ObjectMapperFactory objectMapperFactory) {
        this.objectMapperFactory = objectMapperFactory;
    }

    @JsonProperty(value="jerseyHttpLogging")
    public JerseyHttpLoggingFactory getJerseyHttpLoggingFactory() {
        return this.jerseyHttpLoggingFactory;
    }

    @JsonProperty(value="jerseyHttpLogging")
    public void setJerseyHttpLoggingFactory(JerseyHttpLoggingFactory jerseyHttpLoggingFactory) {
        this.jerseyHttpLoggingFactory = jerseyHttpLoggingFactory;
    }

    @JsonProperty(value="h2")
    public H2Factory getH2Factory() {
        return this.h2Factory;
    }

    @JsonProperty(value="h2")
    public void setH2(H2Factory h2Factory) {
        this.h2Factory = h2Factory;
    }

    @JsonProperty(value="dataSources")
    @JsonUnwrapped
    public NamedDataSourcesFactory getNamedDataSourcesFactory() {
        return this.namedDataSourcesFactory;
    }

    @JsonProperty(value="dataSources")
    @JsonUnwrapped
    public void setNamedDataSourcesFactory(NamedDataSourcesFactory namedDataSourcesFactory) {
        this.namedDataSourcesFactory = namedDataSourcesFactory;
    }

    @JsonProperty(value="connectionManagers")
    @JsonUnwrapped
    public ConnectionManagersFactory getConnectionManagersFactory() {
        return this.connectionManagersFactory;
    }

    @JsonProperty(value="connectionManagers")
    @JsonUnwrapped
    public void setConnectionManagersFactory(ConnectionManagersFactory connectionManagersFactory) {
        this.connectionManagersFactory = connectionManagersFactory;
    }

    @JsonProperty(value="ddlExecutors")
    public List<DdlExecutorFactory> getDdlExecutorFactories() {
        return this.ddlExecutorFactories;
    }

    @JsonProperty(value="ddlExecutors")
    public void setDdlExecutorFactories(List<DdlExecutorFactory> ddlExecutorFactories) {
        this.ddlExecutorFactories = ddlExecutorFactories;
    }

    @JsonProperty(value="reladomo")
    public ReladomoFactory getReladomoFactory() {
        return this.reladomoFactory;
    }

    @JsonProperty(value="reladomo")
    public void setReladomo(ReladomoFactory reladomoFactory) {
        this.reladomoFactory = reladomoFactory;
    }

    @JsonProperty(value="cors")
    public CorsFactory getCorsFactory() {
        return this.corsFactory;
    }

    @JsonProperty(value="cors")
    public void setCors(CorsFactory corsFactory) {
        this.corsFactory = corsFactory;
    }

    @JsonProperty(value="authFilters")
    public List<AuthFilterFactory> getAuthFilterFactories() {
        return this.authFilterFactories;
    }

    @JsonProperty(value="authFilters")
    public void setAuthFilters(List<AuthFilterFactory> authFilterFactories) {
        this.authFilterFactories = authFilterFactories;
    }

    @JsonProperty(value="sampleData")
    public SampleDataFactory getSampleDataFactory() {
        return this.sampleDataFactory;
    }

    @JsonProperty(value="sampleData")
    public void setSampleData(SampleDataFactory sampleDataFactory) {
        this.sampleDataFactory = sampleDataFactory;
    }

    @JsonProperty(value="bootstrap")
    public EnabledFactory getBootstrapFactory() {
        return this.bootstrapFactory;
    }

    @JsonProperty(value="bootstrap")
    public void setBootstrap(EnabledFactory bootstrapFactory) {
        this.bootstrapFactory = bootstrapFactory;
    }

    @JsonProperty(value="systemProperties")
    public SystemPropertiesFactory getSystemPropertiesFactory() {
        return this.systemPropertiesFactory;
    }

    @JsonProperty(value="systemProperties")
    public void setSystemPropertiesFactory(SystemPropertiesFactory systemPropertiesFactory) {
        this.systemPropertiesFactory = systemPropertiesFactory;
    }

    @JsonProperty(value="liquibase")
    public LiquibaseMigrationFactory getLiquibaseMigrationFactory() {
        return this.liquibaseMigrationFactory;
    }

    @JsonProperty(value="liquibase")
    public void setLiquibaseMigrationFactory(LiquibaseMigrationFactory liquibaseMigrationFactory) {
        this.liquibaseMigrationFactory = liquibaseMigrationFactory;
    }

    @JsonIgnore
    public DataStoreFactory getDataStoreFactory() {
        return this.klassFactory.getDataStoreFactory();
    }

    @JsonIgnore
    public DomainModelFactory getDomainModelFactory() {
        return this.klassFactory.getDomainModelFactory();
    }

    @JsonIgnore
    public UUIDSupplierFactory getUuidSupplierFactory() {
        return this.getDataStoreFactory().getUuidFactory();
    }

    @JsonIgnore
    public ClockFactory getClockFactory() {
        return this.klassFactory.getClockFactory();
    }
}

