/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.dropwizard.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import cool.klass.dropwizard.configuration.KlassFactory;
import cool.klass.dropwizard.configuration.data.store.DataStoreFactory;
import cool.klass.dropwizard.configuration.data.store.DataStoreFactoryProvider;
import cool.klass.dropwizard.configuration.domain.model.loader.DomainModelFactory;
import cool.klass.dropwizard.configuration.domain.model.loader.DomainModelFactoryProvider;
import cool.klass.dropwizard.configuration.sample.data.SampleDataFactory;
import cool.klass.dropwizard.configuration.sample.data.SampleDataFactoryProvider;
import io.liftwizard.dropwizard.configuration.connectionmanager.ConnectionManagerProvider;
import io.liftwizard.dropwizard.configuration.connectionmanager.ConnectionManagersFactory;
import io.liftwizard.dropwizard.configuration.datasource.NamedDataSourceProvider;
import io.liftwizard.dropwizard.configuration.datasource.NamedDataSourcesFactory;
import io.liftwizard.dropwizard.configuration.ddl.executor.DdlExecutorFactory;
import io.liftwizard.dropwizard.configuration.ddl.executor.DdlExecutorFactoryProvider;
import io.liftwizard.dropwizard.configuration.enabled.EnabledFactory;
import io.liftwizard.dropwizard.configuration.h2.H2Factory;
import io.liftwizard.dropwizard.configuration.h2.H2FactoryProvider;
import io.liftwizard.dropwizard.configuration.liquibase.migration.LiquibaseMigrationFactory;
import io.liftwizard.dropwizard.configuration.liquibase.migration.LiquibaseMigrationFactoryProvider;
import io.liftwizard.dropwizard.configuration.parent.AbstractLiftwizardConfiguration;
import io.liftwizard.dropwizard.configuration.reladomo.ReladomoFactory;
import io.liftwizard.dropwizard.configuration.reladomo.ReladomoFactoryProvider;
import io.liftwizard.dropwizard.configuration.uuid.UUIDSupplierFactory;
import io.liftwizard.dropwizard.configuration.uuid.UUIDSupplierFactoryProvider;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"server", "logging", "metrics", "klass", "configLogging", "objectMapper", "cors", "authFilters", "jerseyHttpLogging", "h2", "dataSources", "ddlExecutors", "reladomo", "connectionManagers", "sampleData", "bootstrap"})
public abstract class AbstractKlassConfiguration
extends AbstractLiftwizardConfiguration
implements H2FactoryProvider,
DdlExecutorFactoryProvider,
ReladomoFactoryProvider,
SampleDataFactoryProvider,
DataStoreFactoryProvider,
DomainModelFactoryProvider,
UUIDSupplierFactoryProvider,
NamedDataSourceProvider,
ConnectionManagerProvider,
LiquibaseMigrationFactoryProvider {
    @Valid
    private KlassFactory klassFactory;
    @Valid
    private H2Factory h2Factory;
    @Valid
    @NotNull
    private List<DdlExecutorFactory> ddlExecutorFactories = List.of();
    @Valid
    @NotNull
    private ReladomoFactory reladomoFactory = new ReladomoFactory();
    @Valid
    @NotNull
    private SampleDataFactory sampleDataFactory = new SampleDataFactory();
    @Valid
    @NotNull
    private EnabledFactory bootstrapFactory = new EnabledFactory();
    @Valid
    @NotNull
    private LiquibaseMigrationFactory liquibaseMigrationFactory = new LiquibaseMigrationFactory();
    @JsonUnwrapped
    @Valid
    @NotNull
    private NamedDataSourcesFactory namedDataSourcesFactory = new NamedDataSourcesFactory();
    @JsonUnwrapped
    @Valid
    @NotNull
    private ConnectionManagersFactory connectionManagersFactory = new ConnectionManagersFactory();

    @JsonProperty(value="klass")
    public KlassFactory getKlassFactory() {
        return this.klassFactory;
    }

    @JsonProperty(value="klass")
    public void setKlassFactory(KlassFactory klassFactory) {
        this.klassFactory = klassFactory;
    }

    @JsonProperty(value="h2")
    public H2Factory getH2Factory() {
        return this.h2Factory;
    }

    @JsonProperty(value="h2")
    public void setH2(H2Factory h2Factory) {
        this.h2Factory = h2Factory;
    }

    @JsonProperty(value="dataSources")
    @JsonUnwrapped
    public NamedDataSourcesFactory getNamedDataSourcesFactory() {
        return this.namedDataSourcesFactory;
    }

    @JsonProperty(value="dataSources")
    @JsonUnwrapped
    public void setNamedDataSourcesFactory(NamedDataSourcesFactory namedDataSourcesFactory) {
        this.namedDataSourcesFactory = namedDataSourcesFactory;
    }

    @JsonProperty(value="connectionManagers")
    @JsonUnwrapped
    public ConnectionManagersFactory getConnectionManagersFactory() {
        return this.connectionManagersFactory;
    }

    @JsonProperty(value="connectionManagers")
    @JsonUnwrapped
    public void setConnectionManagersFactory(ConnectionManagersFactory connectionManagersFactory) {
        this.connectionManagersFactory = connectionManagersFactory;
    }

    @JsonProperty(value="ddlExecutors")
    public List<DdlExecutorFactory> getDdlExecutorFactories() {
        return this.ddlExecutorFactories;
    }

    @JsonProperty(value="ddlExecutors")
    public void setDdlExecutorFactories(List<DdlExecutorFactory> ddlExecutorFactories) {
        this.ddlExecutorFactories = ddlExecutorFactories;
    }

    @JsonProperty(value="reladomo")
    public ReladomoFactory getReladomoFactory() {
        return this.reladomoFactory;
    }

    @JsonProperty(value="reladomo")
    public void setReladomo(ReladomoFactory reladomoFactory) {
        this.reladomoFactory = reladomoFactory;
    }

    @JsonProperty(value="sampleData")
    public SampleDataFactory getSampleDataFactory() {
        return this.sampleDataFactory;
    }

    @JsonProperty(value="sampleData")
    public void setSampleData(SampleDataFactory sampleDataFactory) {
        this.sampleDataFactory = sampleDataFactory;
    }

    @JsonProperty(value="bootstrap")
    public EnabledFactory getBootstrapFactory() {
        return this.bootstrapFactory;
    }

    @JsonProperty(value="bootstrap")
    public void setBootstrap(EnabledFactory bootstrapFactory) {
        this.bootstrapFactory = bootstrapFactory;
    }

    @JsonProperty(value="liquibase")
    public LiquibaseMigrationFactory getLiquibaseMigrationFactory() {
        return this.liquibaseMigrationFactory;
    }

    @JsonProperty(value="liquibase")
    public void setLiquibaseMigrationFactory(LiquibaseMigrationFactory liquibaseMigrationFactory) {
        this.liquibaseMigrationFactory = liquibaseMigrationFactory;
    }

    @JsonIgnore
    public DataStoreFactory getDataStoreFactory() {
        return this.klassFactory.getDataStoreFactory();
    }

    @JsonIgnore
    public DomainModelFactory getDomainModelFactory() {
        return this.klassFactory.getDomainModelFactory();
    }

    @JsonIgnore
    public UUIDSupplierFactory getUuidSupplierFactory() {
        return this.getDataStoreFactory().getUuidFactory();
    }
}

