/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.plugin;

import cool.klass.model.converter.compiler.CompilationResult;
import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.KlassCompiler;
import cool.klass.model.converter.compiler.annotation.RootCompilerAnnotation;
import cool.klass.model.meta.domain.api.source.DomainModelWithSourceCode;
import cool.klass.model.meta.loader.compiler.DomainModelCompilerLoader;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.list.fixed.ArrayAdapter;
import org.eclipse.collections.impl.list.mutable.ListAdapter;
import org.fusesource.jansi.AnsiConsole;

public abstract class AbstractGenerateMojo
extends AbstractMojo {
    public static final Pattern KLASS_FILE_EXTENSION = Pattern.compile(".*\\.klass");
    @Parameter(property="klassSourcePackages", required=true)
    protected List<String> klassSourcePackages;
    @Parameter(property="logCompilerAnnotations")
    protected boolean logCompilerAnnotations;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject mavenProject;

    @Nonnull
    protected DomainModelWithSourceCode getDomainModelFromFiles() throws MojoExecutionException {
        CompilationResult compilationResult = this.getCompilationResultFromFiles();
        this.handleErrorsCompilationResult(compilationResult);
        return (DomainModelWithSourceCode)compilationResult.domainModelWithSourceCode().get();
    }

    @Nonnull
    private CompilationResult getCompilationResultFromFiles() throws MojoExecutionException {
        MutableList<File> klassLocations = this.loadFiles();
        if (klassLocations.isEmpty()) {
            String message = "Could not find any files matching %s in: %s".formatted(KLASS_FILE_EXTENSION, this.mavenProject.getResources());
            throw new MojoExecutionException(message);
        }
        ImmutableList<CompilationUnit> compilationUnits = this.getCompilationUnits((ImmutableList<File>)klassLocations.toImmutable());
        KlassCompiler klassCompiler = new KlassCompiler(compilationUnits);
        return klassCompiler.compile();
    }

    @Nonnull
    protected DomainModelWithSourceCode getDomainModel() throws MojoExecutionException {
        if (this.klassSourcePackages.isEmpty()) {
            String message = "Klass maven plugins must be configured with at least one klassSourcePackage. For example:\n<klassSourcePackages>\n    <klassSourcePackage>klass.model.meta.domain</klassSourcePackage>\n    <klassSourcePackage>${app.rootPackageName}</klassSourcePackage>\n</klassSourcePackages>";
            throw new MojoExecutionException(message);
        }
        DomainModelCompilerLoader loader = new DomainModelCompilerLoader(Lists.immutable.withAll(this.klassSourcePackages), this.getClassLoader(), this::logCompilerAnnotation);
        return loader.load();
    }

    private MutableList<File> loadFiles() {
        MutableList adaptedKlassSourcePackages = ListAdapter.adapt(this.klassSourcePackages);
        MutableList klassLocations = Lists.mutable.empty();
        for (Resource resource : this.mavenProject.getResources()) {
            this.loadfiles((MutableList<File>)klassLocations, (ListIterable<String>)adaptedKlassSourcePackages, resource);
        }
        return klassLocations;
    }

    private void loadfiles(MutableList<File> resultKlassLocations, ListIterable<String> klassSourcePackages, Resource resource) {
        String directory = resource.getDirectory();
        String message = "Scanning source packages: %s in directory: %s".formatted(klassSourcePackages.makeString(), directory);
        this.getLog().info((CharSequence)message);
        klassSourcePackages.asLazy().collect((Function & Serializable)klassSourcePackage -> klassSourcePackage.replaceAll("\\.", "/")).collect((Function & Serializable)relativeDirectory -> new File(directory, (String)relativeDirectory)).forEach((Procedure & Serializable)file -> {
            File[] files = file.listFiles();
            if (files == null) {
                this.getLog().warn((CharSequence)("Could not find directory: " + file.getAbsolutePath()));
            }
        });
        klassSourcePackages.asLazy().collect((Function & Serializable)klassSourcePackage -> klassSourcePackage.replaceAll("\\.", "/")).collect((Function & Serializable)relativeDirectory -> new File(directory, (String)relativeDirectory)).collect(File::listFiles).reject(Objects::isNull).collect(ArrayAdapter::adapt).forEach((Procedure & Serializable)files -> files.asLazy().select((Predicate & Serializable)file -> KLASS_FILE_EXTENSION.matcher(file.getAbsolutePath()).matches()).into((Collection)resultKlassLocations));
    }

    protected void handleErrorsCompilationResult(CompilationResult compilationResult) throws MojoExecutionException {
        for (RootCompilerAnnotation compilerAnnotation : compilationResult.compilerAnnotations()) {
            this.logCompilerAnnotation(compilerAnnotation);
        }
        if (compilationResult.domainModelWithSourceCode().isEmpty()) {
            throw new MojoExecutionException("There were compiler errors.");
        }
    }

    private void logCompilerAnnotation(RootCompilerAnnotation compilerAnnotation) {
        AnsiConsole.systemInstall();
        if (compilerAnnotation.isError()) {
            this.getLog().info((CharSequence)("\n" + compilerAnnotation.toGitHubAnnotation()));
            this.getLog().error((CharSequence)("\n" + String.valueOf(compilerAnnotation)));
        } else if (compilerAnnotation.isWarning() && this.logCompilerAnnotations) {
            this.getLog().info((CharSequence)("\n" + compilerAnnotation.toGitHubAnnotation()));
            this.getLog().warn((CharSequence)("\n" + String.valueOf(compilerAnnotation)));
        }
    }

    private ImmutableList<CompilationUnit> getCompilationUnits(ImmutableList<File> klassLocations) {
        this.getLog().debug((CharSequence)("Found source files on classpath: " + String.valueOf(klassLocations)));
        ImmutableList compilationUnits = klassLocations.collectWithIndex((ObjectIntToObjectFunction & Serializable)(each, index) -> CompilationUnit.createFromFile((int)index, (File)each));
        return compilationUnits;
    }

    @Nonnull
    private ClassLoader getClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.mavenProject.getCompileClasspathElements();
            MutableList projectClasspathList = Lists.mutable.empty();
            for (String element : classpathElements) {
                URL url = AbstractGenerateMojo.getUrl(element);
                projectClasspathList.add((Object)url);
            }
            URL[] urls = (URL[])projectClasspathList.toArray((Object[])new URL[0]);
            return new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Dependency resolution failed", (Exception)((Object)e));
        }
    }

    @Nonnull
    private static URL getUrl(@Nonnull String classpathElement) throws MojoExecutionException {
        try {
            return new File(classpathElement).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(classpathElement + " is an invalid classpath element", (Exception)e);
        }
    }
}

