/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.dropwizard.plugin;

import cool.klass.generator.dropwizard.ApplicationSuperClassGenerator;
import cool.klass.generator.plugin.AbstractGenerateMojo;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.source.DomainModelWithSourceCode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-abstract-application", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class GenerateAbstractApplicationMojo
extends AbstractGenerateMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-sources/abstract-application")
    private File outputDirectory;
    @Parameter(property="rootPackageName", required=true)
    private String rootPackageName;
    @Parameter(property="applicationName", required=true)
    private String applicationName;

    public void execute() throws MojoExecutionException {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        DomainModelWithSourceCode domainModel = this.getDomainModel();
        Path outputPath = this.outputDirectory.toPath();
        try {
            ApplicationSuperClassGenerator abstractApplicationGenerator = new ApplicationSuperClassGenerator((DomainModel)domainModel, this.rootPackageName, this.applicationName);
            abstractApplicationGenerator.writeAbstractApplicationFile(outputPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.mavenProject.addCompileSourceRoot(this.outputDirectory.getPath());
    }
}

