/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.dropwizard;

import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.service.ServiceGroup;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ApplicationSuperClassGenerator {
    @Nonnull
    private final DomainModel domainModel;
    @Nonnull
    private final String rootPackageName;
    @Nonnull
    private final String applicationName;
    @Nonnull
    private final String packageName;
    @Nonnull
    private final String relativePath;

    public ApplicationSuperClassGenerator(@Nonnull DomainModel domainModel, @Nonnull String rootPackageName, @Nonnull String applicationName) {
        this.domainModel = Objects.requireNonNull(domainModel);
        this.rootPackageName = Objects.requireNonNull(rootPackageName);
        this.applicationName = Objects.requireNonNull(applicationName);
        this.packageName = rootPackageName + ".dropwizard.application";
        this.relativePath = this.packageName.replaceAll("\\.", "/");
    }

    public void writeAbstractApplicationFile(@Nonnull Path outputPath) throws IOException {
        Path path = outputPath.resolve(this.relativePath);
        path.toFile().mkdirs();
        Path javaPath = path.resolve("Abstract" + this.applicationName + "Application.java");
        String sourceCode = "package " + this.packageName + ";\n\nimport java.time.Clock;\n\nimport javax.annotation.Nonnull;\n\nimport com.fasterxml.jackson.databind.ObjectMapper;\nimport cool.klass.data.store.DataStore;\nimport cool.klass.dropwizard.configuration.KlassFactory;\nimport cool.klass.model.meta.domain.api.DomainModel;\nimport cool.klass.model.meta.domain.api.source.DomainModelWithSourceCode;\nimport cool.klass.service.klass.html.KlassHtmlResource;\nimport io.dropwizard.setup.Environment;\nimport io.liftwizard.dropwizard.application.AbstractLiftwizardApplication;\n" + this.getResourceImports() + "import org.slf4j.Logger;\nimport org.slf4j.LoggerFactory;\n\n/**\n * Auto-generated by {@link " + this.getClass().getCanonicalName() + "}\n */\npublic abstract class Abstract" + this.applicationName + "Application\n        extends AbstractLiftwizardApplication<" + this.applicationName + "Configuration>\n{\n    private static final Logger LOGGER = LoggerFactory.getLogger(Abstract" + this.applicationName + "Application.class);\n\n    public Abstract" + this.applicationName + "Application()\n    {\n        super(\"" + this.applicationName + "\");\n    }\n\n    @Override\n    public void run(\n            @Nonnull " + this.applicationName + "Configuration configuration,\n            @Nonnull Environment environment) throws Exception\n    {\n        super.run(configuration, environment);\n\n        ObjectMapper objectMapper = environment.getObjectMapper();\n        KlassFactory klassFactory = configuration.getKlassFactory();\n        DataStore    dataStore    = klassFactory.getDataStoreFactory().createDataStore();\n        DomainModel  domainModel  = klassFactory.getDomainModelFactory().createDomainModel(objectMapper);\n        Clock        clock        = configuration.getClockFactory().createClock();\n\n        if (domainModel instanceof DomainModelWithSourceCode domainModelWithSourceCode)\n        {\n            environment.jersey().register(new KlassHtmlResource(domainModelWithSourceCode));\n        }\n\n" + this.getRegisterResourcesSourceCode() + "    }\n}\n";
        this.printStringToFile(javaPath, sourceCode);
    }

    private String getResourceImports() {
        return this.domainModel.getServiceGroups().collect(this::getResourceImport).makeString("");
    }

    private String getRegisterResourcesSourceCode() {
        return this.domainModel.getServiceGroups().collect(this::getRegisterResourceSourceCode).makeString("");
    }

    private String getResourceImport(ServiceGroup serviceGroup) {
        return String.format("import %s.service.resource.%s;\n", serviceGroup.getPackageName(), serviceGroup.getName());
    }

    private String getRegisterResourceSourceCode(@Nonnull ServiceGroup serviceGroup) {
        return String.format("        environment.jersey().register(new %s(domainModel, dataStore, clock));\n", serviceGroup.getName());
    }

    private void printStringToFile(@Nonnull Path path, String contents) throws FileNotFoundException {
        try (PrintStream printStream = new PrintStream(new FileOutputStream(path.toFile()));){
            printStream.print(contents);
        }
    }
}

