/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.dto.plugin;

import cool.klass.generator.dto.DataTransferObjectsGenerator;
import cool.klass.generator.plugin.AbstractGenerateMojo;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.source.DomainModelWithSourceCode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-data-transfer-objects", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class GenerateDataTransferObjectsMojo
extends AbstractGenerateMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-sources/data-transfer-objects")
    private File outputDirectory;

    public void execute() throws MojoExecutionException {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        DomainModelWithSourceCode domainModel = this.getDomainModel();
        Path outputPath = this.outputDirectory.toPath();
        try {
            DataTransferObjectsGenerator dataTransferObjectsGenerator = new DataTransferObjectsGenerator((DomainModel)domainModel);
            dataTransferObjectsGenerator.writeDataTransferObjectFiles(outputPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.mavenProject.addCompileSourceRoot(this.outputDirectory.getPath());
    }
}

