/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.grahql.schema;

import cool.klass.generator.grahql.schema.GraphQLElementToSchemaSourceVisitor;
import cool.klass.generator.perpackage.AbstractPerPackageGenerator;
import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.TopLevelElement;
import cool.klass.model.meta.domain.api.TopLevelElementVisitor;
import java.nio.file.Path;
import javax.annotation.Nonnull;

public class GraphQLSchemaGenerator
extends AbstractPerPackageGenerator {
    public GraphQLSchemaGenerator(@Nonnull DomainModel domainModel) {
        super(domainModel);
    }

    @Nonnull
    protected Path getPluginRelativePath(Path path) {
        return path.resolve("graphql").resolve("schema");
    }

    @Nonnull
    protected String getFileName() {
        return "GraphQLSchema.graphqls";
    }

    @Nonnull
    protected String getPackageSourceCode(@Nonnull String fullyQualifiedPackage) {
        String orderBySourceCode = this.domainModel.getClassifiers().collect(this::getOrderBySourceCode).makeString("");
        String topLevelElementsCode = this.domainModel.getTopLevelElements().collect(this::getSourceCode).makeString("");
        String sourceCode = "# Generated by cool.klass.generator.grahql.schema.GraphQLSchemaGenerator\n\n# Order Bys\n" + orderBySourceCode + "\n# Top Level Elements\n" + topLevelElementsCode;
        return sourceCode;
    }

    private String getOrderBySourceCode(Classifier classifier) {
        return "input _" + classifier.getName() + "OrderBy {\n    attribute: _" + classifier.getName() + "Finder\n    direction: _OrderByDirection\n}\n\n";
    }

    private String getSourceCode(@Nonnull TopLevelElement topLevelElement) {
        GraphQLElementToSchemaSourceVisitor visitor = new GraphQLElementToSchemaSourceVisitor();
        topLevelElement.visit((TopLevelElementVisitor)visitor);
        return visitor.getSourceCode();
    }
}

