/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.klass.html;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import cool.klass.model.converter.compiler.token.categories.TokenCategory;
import cool.klass.model.meta.domain.api.EnumerationLiteral;
import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.TopLevelElement;
import cool.klass.model.meta.domain.api.property.Property;
import cool.klass.model.meta.domain.api.source.DomainModelWithSourceCode;
import cool.klass.model.meta.domain.api.source.ElementWithSourceCode;
import cool.klass.model.meta.domain.api.source.SourceCode;
import cool.klass.model.meta.domain.api.source.TopLevelElementWithSourceCode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.Token;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.list.mutable.ListAdapter;

public class KlassSourceCodeHtmlGenerator {
    public static final Converter<String, String> CONVERTER = CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_HYPHEN);
    private final DomainModelWithSourceCode domainModel;

    public KlassSourceCodeHtmlGenerator(DomainModelWithSourceCode domainModel) {
        this.domainModel = Objects.requireNonNull(domainModel);
    }

    public static String getSourceCode(Token token, DomainModelWithSourceCode domainModel, Optional<TopLevelElementWithSourceCode> topLevelElementToHighlight, Optional<String> memberNameToHighlight) {
        Optional maybeTokenCategory = domainModel.getTokenCategory(token);
        Optional maybeElementByReference = domainModel.getElementByReference(token);
        Optional maybeElementByDeclaration = domainModel.getElementByDeclaration(token);
        String escapedText = StringEscapeUtils.escapeHtml4((String)token.getText());
        if (maybeTokenCategory.isEmpty() && maybeElementByReference.isEmpty() && maybeElementByDeclaration.isEmpty()) {
            return escapedText;
        }
        if (maybeTokenCategory.isEmpty()) {
            throw new AssertionError(token);
        }
        TokenCategory tokenCategory = (TokenCategory)maybeTokenCategory.get();
        if (maybeElementByReference.isEmpty() && maybeElementByDeclaration.isEmpty()) {
            return KlassSourceCodeHtmlGenerator.getSpan(escapedText, tokenCategory, false);
        }
        if (maybeElementByDeclaration.isPresent() && maybeElementByReference.isEmpty()) {
            ElementWithSourceCode element = (ElementWithSourceCode)maybeElementByDeclaration.get();
            String idForElement = KlassSourceCodeHtmlGenerator.getIdForElement(element);
            String linkForElement = KlassSourceCodeHtmlGenerator.getLinkForElement(element);
            String escapedName = StringEscapeUtils.escapeHtml4((String)((NamedElement)element).getName());
            String declarationAnchor = "<a id=\"%s\" href=\"%s\">%s</a>".formatted(idForElement, linkForElement, escapedName);
            boolean shouldHighlight = KlassSourceCodeHtmlGenerator.matchesElementToHighlight((ElementWithSourceCode)maybeElementByDeclaration.get(), topLevelElementToHighlight, memberNameToHighlight);
            return KlassSourceCodeHtmlGenerator.getSpan(declarationAnchor, tokenCategory, shouldHighlight);
        }
        if (maybeElementByDeclaration.isEmpty() && maybeElementByReference.isPresent()) {
            String linkForElement = KlassSourceCodeHtmlGenerator.getLinkForElement((ElementWithSourceCode)maybeElementByReference.get());
            String referenceAnchor = "<a href=\"%s\">%s</a>".formatted(linkForElement, escapedText);
            return KlassSourceCodeHtmlGenerator.getSpan(referenceAnchor, tokenCategory, false);
        }
        throw new AssertionError(token);
    }

    public static String getSourceCode(@Nonnull DomainModelWithSourceCode domainModel, @Nonnull SourceCode sourceCode) {
        return KlassSourceCodeHtmlGenerator.getSourceCode(domainModel, sourceCode, Optional.empty(), Optional.empty());
    }

    public static String getSourceCode(@Nonnull DomainModelWithSourceCode domainModel, @Nonnull SourceCode sourceCode, @Nonnull Optional<TopLevelElementWithSourceCode> topLevelElementToHighlight, @Nonnull Optional<String> memberNameToHighlight) {
        Objects.requireNonNull(domainModel);
        Objects.requireNonNull(sourceCode);
        Objects.requireNonNull(topLevelElementToHighlight);
        Objects.requireNonNull(memberNameToHighlight);
        BufferedTokenStream tokenStream = sourceCode.getTokenStream();
        MutableList tokens = ListAdapter.adapt((List)tokenStream.getTokens());
        String body = tokens.reject((Predicate & Serializable)token -> token.getType() == -1).collect((Function & Serializable)token -> KlassSourceCodeHtmlGenerator.getSourceCode(token, domainModel, topLevelElementToHighlight, memberNameToHighlight)).makeString("");
        String prefix = "<html>\n<head>\n    <link rel='stylesheet' type='text/css' href='/static/css/light.css' media='(prefers-color-scheme: light)'>\n    <link rel='stylesheet' type='text/css' href='/static/css/dark.css' media='(prefers-color-scheme: dark)'>\n    <link rel='stylesheet' type='text/css' href='/static/css/slider.css'>\n    <link rel='stylesheet' type='text/css' href='/static/css/klass-syntax.css'>\n    <script type='module' src='https://unpkg.com/dark-mode-toggle'></script>\n    <style>\n        :root {\n            font-family: \"Lucida Console\", Courier, monospace;\n            font-size: 16px;\n        }\n    </style>\n</head>\n<body class='klass'>\n<aside>\n    <dark-mode-toggle class='slider' legend='Dark Mode' appearance='toggle'></dark-mode-toggle>\n</aside>\n<pre>\n";
        return prefix + body + "</pre>\n</body>\n</html>\n";
    }

    private static boolean matchesElementToHighlight(ElementWithSourceCode element, Optional<TopLevelElementWithSourceCode> topLevelElementToHighlight, Optional<String> memberNameToHighlight) {
        if (element instanceof TopLevelElement && memberNameToHighlight.isPresent()) {
            return false;
        }
        if (memberNameToHighlight.isEmpty()) {
            return Optional.of(element).equals(topLevelElementToHighlight);
        }
        if (element instanceof Property) {
            Property property = (Property)element;
            return Optional.of(property.getName()).equals(memberNameToHighlight) && Optional.of(property.getOwningClassifier()).equals(topLevelElementToHighlight);
        }
        if (element instanceof EnumerationLiteral) {
            EnumerationLiteral enumerationLiteral = (EnumerationLiteral)element;
            return Optional.of(enumerationLiteral.getName()).equals(memberNameToHighlight) && Optional.of(enumerationLiteral.getType()).equals(topLevelElementToHighlight);
        }
        return false;
    }

    @Nonnull
    private static String getSpan(String text, TokenCategory tokenCategory, boolean matchesHighlight) {
        String tokenCategoryName = tokenCategory.name();
        String className = (String)CONVERTER.convert((Object)tokenCategoryName);
        String highlightClassName = matchesHighlight ? " highlight" : "";
        return "<span class='klass-" + className + highlightClassName + "'>" + text + "</span>";
    }

    private void writeHtmlFile(SourceCode sourceCode, Path outputPath) {
        Path htmlOutputPath = KlassSourceCodeHtmlGenerator.getOutputPath(outputPath, sourceCode);
        String sourceCodeText = KlassSourceCodeHtmlGenerator.getSourceCode(this.domainModel, sourceCode);
        KlassSourceCodeHtmlGenerator.printStringToFile(htmlOutputPath, sourceCodeText);
    }

    @Nonnull
    private static Path getOutputPath(@Nonnull Path outputPath, @Nonnull SourceCode sourceCode) {
        Path parentPath = KlassSourceCodeHtmlGenerator.getParentPath(sourceCode);
        Path absoluteParentPath = outputPath.resolve(parentPath);
        Objects.requireNonNull(absoluteParentPath);
        File absoluteParentFile = absoluteParentPath.toFile();
        Objects.requireNonNull(absoluteParentFile);
        absoluteParentFile.mkdirs();
        String fileName = sourceCode.getSourceName() + ".html";
        return outputPath.resolve(fileName);
    }

    private static Path getParentPath(SourceCode sourceCode) {
        return sourceCode.getMacroSourceCode().map(KlassSourceCodeHtmlGenerator::getParentPath).orElseGet(() -> KlassSourceCodeHtmlGenerator.getRootParentPath(sourceCode));
    }

    private static Path getRootParentPath(SourceCode sourceCode) {
        String sourceName = sourceCode.getSourceName();
        File sourceFile = new File(sourceName);
        return sourceFile.toPath().getParent();
    }

    private static void printStringToFile(@Nonnull Path path, String contents) {
        try (PrintStream printStream = new PrintStream(new FileOutputStream(path.toFile()));){
            printStream.print(contents);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeHtmlFiles(@Nonnull Path outputPath) {
        this.domainModel.getSourceCodes().select((Predicate & Serializable)sourceCode -> sourceCode.getMacroSourceCode().isEmpty()).forEachWith(this::writeHtmlFile, (Object)outputPath);
    }

    @Nullable
    private static String getIdForElement(ElementWithSourceCode value) {
        if (value instanceof TopLevelElement) {
            TopLevelElement topLevelElement = (TopLevelElement)value;
            return StringEscapeUtils.escapeHtml4((String)topLevelElement.getName());
        }
        if (value instanceof Property) {
            Property property = (Property)value;
            return StringEscapeUtils.escapeHtml4((String)(property.getOwningClassifier().getName() + "." + property.getName()));
        }
        if (value instanceof EnumerationLiteral) {
            EnumerationLiteral enumerationLiteral = (EnumerationLiteral)value;
            return StringEscapeUtils.escapeHtml4((String)(enumerationLiteral.getType().getName() + "." + enumerationLiteral.getName()));
        }
        throw new AssertionError(value);
    }

    @Nonnull
    private static String getLinkForElement(ElementWithSourceCode element) {
        if (element instanceof TopLevelElement) {
            TopLevelElement topLevelElement = (TopLevelElement)element;
            return String.format("/api/meta/code/element/%s#%s", topLevelElement.getName(), topLevelElement.getName());
        }
        if (element instanceof Property) {
            Property property = (Property)element;
            return MessageFormat.format("/api/meta/code/element/{0}/{1}#{0}.{1}", property.getOwningClassifier().getName(), property.getName());
        }
        if (element instanceof EnumerationLiteral) {
            EnumerationLiteral enumerationLiteral = (EnumerationLiteral)element;
            return MessageFormat.format("/api/meta/code/element/{0}/{1}#{0}.{1}", enumerationLiteral.getType().getName(), enumerationLiteral.getName());
        }
        throw new AssertionError(element);
    }
}

