/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.klass.projection;

import cool.klass.generator.klass.projection.KlassProjectionGenerator;
import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.property.ReferenceProperty;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.impl.factory.Lists;

public final class KlassProjectionSourceCodeGenerator {
    private KlassProjectionSourceCodeGenerator() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    @Nonnull
    public static String getPackageSourceCode(DomainModel domainModel, String fullyQualifiedPackage) {
        String sourceCode = domainModel.getClassifiers().select((Predicate & Serializable)c -> c.getPackageName().equals(fullyQualifiedPackage)).collect(KlassProjectionSourceCodeGenerator::getClassifierSourceCode).makeString("\n");
        return "package " + fullyQualifiedPackage + ".inference\n\n/*\n * Auto-generated by {@link " + KlassProjectionGenerator.class.getCanonicalName() + "}\n */\n\n" + sourceCode;
    }

    private static String getClassifierSourceCode(Classifier classifier) {
        ImmutableList immutableList;
        String dataTypePropertiesSourceCode = KlassProjectionSourceCodeGenerator.getDataTypePropertiesSourceCode(classifier, false).makeString("");
        String referencePropertiesSourceCode = KlassProjectionSourceCodeGenerator.getReferencePropertiesSourceCode(classifier, false).makeString("");
        if (classifier instanceof Klass) {
            Klass klass = (Klass)classifier;
            immutableList = klass.getSubClassChain();
        } else {
            immutableList = Lists.immutable.empty();
        }
        ImmutableList subClasses = immutableList;
        String subClassesSourceCode = subClasses.collect(KlassProjectionSourceCodeGenerator::getSubClassSourceCode).makeString("");
        if (dataTypePropertiesSourceCode.isEmpty() && referencePropertiesSourceCode.isEmpty() && subClassesSourceCode.isEmpty()) {
            return "";
        }
        return "projection " + classifier.getName() + "Projection on " + classifier.getName() + "\n{\n" + dataTypePropertiesSourceCode + referencePropertiesSourceCode + subClassesSourceCode + "}\n";
    }

    @Nonnull
    private static String getSubClassSourceCode(Klass subClass) {
        String dataTypePropertiesSourceCode = KlassProjectionSourceCodeGenerator.getDataTypePropertiesSourceCode((Classifier)subClass, true).makeString("");
        String referencePropertiesSourceCode = KlassProjectionSourceCodeGenerator.getReferencePropertiesSourceCode((Classifier)subClass, true).makeString("");
        if (dataTypePropertiesSourceCode.isEmpty() && referencePropertiesSourceCode.isEmpty()) {
            return "";
        }
        return dataTypePropertiesSourceCode + referencePropertiesSourceCode;
    }

    private static ImmutableList<String> getDataTypePropertiesSourceCode(Classifier classifier, boolean subClassMode) {
        ImmutableList dataTypeProperties = subClassMode ? classifier.getDeclaredDataTypeProperties() : classifier.getDataTypeProperties();
        return dataTypeProperties.reject(DataTypeProperty::isPrivate).reject((Predicate & Serializable)property -> property.isForeignKey() && !property.isForeignKeyToSelf()).collectWith(KlassProjectionSourceCodeGenerator::getDataTypePropertySourceCode, (Object)subClassMode);
    }

    private static String getDataTypePropertySourceCode(DataTypeProperty dataTypeProperty, boolean subClassMode) {
        String prefix = subClassMode ? dataTypeProperty.getOwningClassifier().getName() + "." : "";
        return String.format("    %s%s: \"%s %s\",\n", prefix, dataTypeProperty.getName(), dataTypeProperty.getOwningClassifier().getName(), dataTypeProperty.getName());
    }

    private static ImmutableList<String> getReferencePropertiesSourceCode(Classifier classifier, boolean subClassMode) {
        ImmutableList properties = subClassMode ? classifier.getDeclaredReferenceProperties() : classifier.getReferenceProperties();
        return properties.select(KlassProjectionSourceCodeGenerator::includeInProjection).reject(ReferenceProperty::isPrivate).collectWith(KlassProjectionSourceCodeGenerator::getReferencePropertySourceCode, (Object)subClassMode);
    }

    private static String getReferencePropertySourceCode(ReferenceProperty referenceProperty, boolean subClassMode) {
        if (referenceProperty.isOwned() || KlassProjectionSourceCodeGenerator.isOneRequiredToOneOptional(referenceProperty)) {
            String prefix = subClassMode ? referenceProperty.getOwningClassifier().getName() + "." : "";
            return String.format("    %s%s: %sProjection,\n", prefix, referenceProperty.getName(), referenceProperty.getType().getName());
        }
        String prefix = subClassMode ? referenceProperty.getOwningClassifier().getName() + "." : "";
        Classifier classifier = referenceProperty.getType();
        ImmutableList keyPropertiesSourceCode = classifier.getKeyProperties().reject(DataTypeProperty::isPrivate).reject((Predicate & Serializable)property -> property.isForeignKey() && !property.isForeignKeyToSelf()).collectWith(KlassProjectionSourceCodeGenerator::getDataTypePropertySourceCode, (Object)subClassMode);
        String result = "    %s%s: {\n%s    },\n".formatted(prefix, referenceProperty.getName(), keyPropertiesSourceCode.makeString("    ", "    ", ""));
        return result;
    }

    private static boolean isOneRequiredToOneOptional(ReferenceProperty referenceProperty) {
        AssociationEnd associationEnd;
        return referenceProperty instanceof AssociationEnd && (associationEnd = (AssociationEnd)referenceProperty).getMultiplicity().isToOne() && !associationEnd.getMultiplicity().isRequired() && associationEnd.getOpposite().getMultiplicity().isToOne() && associationEnd.getOpposite().getMultiplicity().isRequired();
    }

    private static boolean includeInProjection(ReferenceProperty referenceProperty) {
        AssociationEnd associationEnd;
        return !(referenceProperty instanceof AssociationEnd) || (associationEnd = (AssociationEnd)referenceProperty).getOwningAssociation().getTargetAssociationEnd() == associationEnd || associationEnd.isToSelf() && associationEnd.getMultiplicity().isToOne();
    }
}

