/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.klass.service;

import com.google.common.base.CaseFormat;
import cool.klass.generator.klass.service.KlassServiceGenerator;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import java.io.Serializable;
import java.text.MessageFormat;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.ListIterable;

public final class KlassServiceSourceCodeGenerator {
    private KlassServiceSourceCodeGenerator() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    @Nonnull
    public static String getPackageSourceCode(@Nonnull DomainModel domainModel, @Nonnull String fullyQualifiedPackage) {
        String sourceCode = domainModel.getClasses().select((Predicate & Serializable)c -> c.getPackageName().equals(fullyQualifiedPackage)).reject(Klass::isUniquelyOwned).collect(KlassServiceSourceCodeGenerator::getSourceCode).makeString("");
        return "package " + fullyQualifiedPackage + ".inference\n\n/*\n * Auto-generated by {@link " + KlassServiceGenerator.class.getCanonicalName() + "}\n */\n\n" + sourceCode;
    }

    private static String getSourceCode(Klass klass) {
        String className = klass.getName();
        String lowercaseName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, className);
        ListIterable<String> urlPaths = KlassServiceSourceCodeGenerator.getUrlPaths(klass);
        ListIterable<String> criteria = KlassServiceSourceCodeGenerator.getCriteria(klass);
        return "service " + className + "Resource on " + className + "\n{\n    /" + lowercaseName + urlPaths.makeString("") + "\n        GET\n        {\n            multiplicity: one;\n            criteria    : " + criteria.makeString(" && ") + ";\n            projection  : " + className + "Projection;\n        }\n    /" + lowercaseName + "\n        GET\n        {\n            multiplicity: many;\n            criteria    : all;\n            projection  : " + className + "Projection;\n        }\n}\n\n";
    }

    private static ListIterable<String> getUrlPaths(Klass klass) {
        return klass.getKeyProperties().collect(KlassServiceSourceCodeGenerator::getUrlPath);
    }

    private static String getUrlPath(DataTypeProperty dataTypeProperty) {
        String name = dataTypeProperty.getName();
        String type = dataTypeProperty.getType().getDataTypeName();
        String multiplicity = dataTypeProperty.isRequired() ? "1..1" : "0..1";
        return String.format("/{%s: %s[%s]}", name, type, multiplicity);
    }

    private static ListIterable<String> getCriteria(Klass klass) {
        return klass.getKeyProperties().collect(NamedElement::getName).collect((Function & Serializable)name -> MessageFormat.format("this.{0} == {0}", name));
    }
}

