/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.liquibase.schema;

import cool.klass.generator.liquibase.schema.TableGenerator;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import java.io.Serializable;
import java.util.Optional;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.api.tuple.Pair;

public final class ForeignKeyGenerator {
    private ForeignKeyGenerator() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static Optional<String> getForeignKeys(Klass klass, int ordinal) {
        MutableOrderedMap foreignKeys = klass.getForeignKeys().reject((Predicate2 & Serializable)(key, value) -> key.getOwningClassifier().isTemporal() || key.getType().isTemporal());
        if (foreignKeys.isEmpty()) {
            return Optional.empty();
        }
        ImmutableList foreignKeyStrings = foreignKeys.keyValuesView().reject(ForeignKeyGenerator::isSelfToOneOptional).collect((Function & Serializable)keyValuePair -> ForeignKeyGenerator.getForeignKey((AssociationEnd)keyValuePair.getOne(), (MutableOrderedMap<DataTypeProperty, DataTypeProperty>)((MutableOrderedMap)keyValuePair.getTwo()), ordinal)).toImmutableList();
        String result = foreignKeyStrings.makeString("");
        return Optional.of(result);
    }

    private static boolean isSelfToOneOptional(Pair<AssociationEnd, MutableOrderedMap<DataTypeProperty, DataTypeProperty>> pair) {
        AssociationEnd associationEnd = (AssociationEnd)pair.getOne();
        boolean result = associationEnd.isToSelf() && associationEnd.getMultiplicity().isToOne() && !associationEnd.getMultiplicity().isRequired();
        return result;
    }

    private static String getForeignKey(AssociationEnd associationEnd, MutableOrderedMap<DataTypeProperty, DataTypeProperty> dataTypeProperties, int ordinal) {
        String tableName = (String)TableGenerator.TABLE_NAME_CONVERTER.convert((Object)associationEnd.getOwningClassifier().getName());
        String constraintName = tableName + "_FK_" + (String)TableGenerator.TABLE_NAME_CONVERTER.convert((Object)associationEnd.getName());
        String foreignKeyColumnNames = dataTypeProperties.keysView().collect(NamedElement::getName).collect(arg_0 -> TableGenerator.COLUMN_NAME_CONVERTER.convert(arg_0)).makeString(", ");
        String referencedTableName = (String)TableGenerator.TABLE_NAME_CONVERTER.convert((Object)associationEnd.getType().getName());
        String referencedKeyColumnNames = dataTypeProperties.valuesView().collect(NamedElement::getName).collect(arg_0 -> TableGenerator.COLUMN_NAME_CONVERTER.convert(arg_0)).makeString(", ");
        String format = "    <changeSet author=\"Klass\" id=\"initial-foreign-key-%d-%s\">\n        <addForeignKeyConstraint\n                constraintName=\"%s\"\n                baseTableName=\"%s\"\n                baseColumnNames=\"%s\"\n                referencedTableName=\"%s\"\n                referencedColumnNames=\"%s\"\n        />\n    </changeSet>\n\n";
        return format.formatted(ordinal, constraintName, constraintName, tableName, foreignKeyColumnNames, referencedTableName, referencedKeyColumnNames);
    }
}

