/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.liquibase.schema;

import cool.klass.generator.liquibase.schema.TableGenerator;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import java.io.Serializable;
import java.util.Objects;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableOrderedMap;

public final class IndexGenerator {
    private IndexGenerator() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static String getIndex(Klass klass, int ordinal) {
        String tableName = TableGenerator.getTableName(klass);
        MutableOrderedMap foreignKeyConstraints = klass.getForeignKeys();
        MutableList result = foreignKeyConstraints.keyValuesView().collect((Function & Serializable)keyValuePair -> IndexGenerator.getForeignKeyIndex((AssociationEnd)keyValuePair.getOne(), (MutableOrderedMap<DataTypeProperty, DataTypeProperty>)((MutableOrderedMap)keyValuePair.getTwo()), klass, tableName, ordinal)).reject(String::isEmpty).toList();
        if (!Objects.equals(result, result.distinct())) {
            throw new AssertionError((Object)("Duplicate foreign key index detected for " + tableName + " in " + klass.getName() + ". Indexes: " + result));
        }
        return result.makeString("");
    }

    private static String getForeignKeyIndex(AssociationEnd associationEnd, MutableOrderedMap<DataTypeProperty, DataTypeProperty> dataTypeProperties, Klass klass, String tableName, int ordinal) {
        String constraintName = tableName + "_IDX_" + (String)TableGenerator.TABLE_NAME_CONVERTER.convert((Object)associationEnd.getName());
        ImmutableList toProperties = klass.getDataTypeProperties().select(DataTypeProperty::isTo);
        ImmutableList allKeyProperties = dataTypeProperties.keysView().asLazy().concatenate((Iterable)toProperties).toImmutableList();
        if (IndexGenerator.isPrefixList((ImmutableList<DataTypeProperty>)allKeyProperties, IndexGenerator.getAllKeyProperties(klass))) {
            return "";
        }
        ImmutableList foreignKeyColumns = allKeyProperties.collect(NamedElement::getName).collect(arg_0 -> TableGenerator.COLUMN_NAME_CONVERTER.convert(arg_0)).collect((Function & Serializable)columnName -> "            <column name=\"" + columnName + "\" />\n");
        return "    <changeSet author=\"Klass\" id=\"initial-indices-" + ordinal + "-" + constraintName + "\">\n        <createIndex\n                indexName=\"" + constraintName + "\"\n                tableName=\"" + tableName + "\">\n" + foreignKeyColumns.makeString("") + "        </createIndex>\n    </changeSet>\n\n";
    }

    private static boolean isPrefixList(ImmutableList<DataTypeProperty> list1, ImmutableList<DataTypeProperty> list2) {
        if (list1.size() > list2.size()) {
            return false;
        }
        return list1.equals((Object)list2.subList(0, list1.size()));
    }

    private static ImmutableList<DataTypeProperty> getAllKeyProperties(Klass klass) {
        ImmutableList toProperties = klass.getDataTypeProperties().select(DataTypeProperty::isTo);
        return klass.getKeyProperties().newWithAll((Iterable)toProperties);
    }
}

