/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.liquibase.schema;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import cool.klass.generator.liquibase.schema.LiquibaseSchemaGeneratorDataTypePropertyVisitor;
import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.visitor.DataTypePropertyVisitor;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.list.ImmutableListFactory;
import org.eclipse.collections.api.list.ImmutableList;

public final class TableGenerator {
    public static final Converter<String, String> TABLE_NAME_CONVERTER = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE);
    public static final Converter<String, String> COLUMN_NAME_CONVERTER = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE);

    private TableGenerator() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static String getTable(@Nonnull Klass klass, int ordinal) {
        Objects.requireNonNull(klass);
        String tableName = TableGenerator.getTableName(klass);
        String propertiesSourceCode = TableGenerator.getPropertiesSourceCode(klass, tableName);
        return "    <changeSet author=\"Klass\" id=\"initial-table-" + ordinal + "-" + tableName + "\">\n        <createTable tableName=\"" + tableName + "\">\n" + propertiesSourceCode + "        </createTable>\n    </changeSet>\n\n";
    }

    @Nonnull
    public static String getTableName(@Nonnull Klass klass) {
        return (String)TABLE_NAME_CONVERTER.convert((Object)klass.getName());
    }

    @Nonnull
    private static String getPropertiesSourceCode(@Nonnull Klass klass, String tableName) {
        return TableGenerator.getDataTypeProperties(klass).reject(DataTypeProperty::isDerived).reject(DataTypeProperty::isTemporalRange).collect((Function & Serializable)dataTypeProperty -> TableGenerator.getPropertySourceCode(dataTypeProperty, tableName)).makeString("\n");
    }

    private static ImmutableList<DataTypeProperty> getDataTypeProperties(@Nonnull Klass klass) {
        ImmutableList superClassPropertyNames = klass.getSuperClass().map(Classifier::getDataTypeProperties).orElseGet(() -> ((ImmutableListFactory)Lists.immutable).empty()).collect(NamedElement::getName);
        return klass.getDataTypeProperties().select((Predicate & Serializable)each -> each.isKey() || !superClassPropertyNames.contains((Object)each.getName()));
    }

    private static String getPropertySourceCode(DataTypeProperty dataTypeProperty, String tableName) {
        String name = (String)COLUMN_NAME_CONVERTER.convert((Object)dataTypeProperty.getName());
        String dataType = TableGenerator.getDataType(dataTypeProperty);
        String nullability = TableGenerator.getNullability(dataTypeProperty);
        String primaryKey = TableGenerator.getPrimaryKey(dataTypeProperty, tableName);
        if (nullability.isEmpty() && primaryKey.isEmpty()) {
            return "            <column name=\"" + name + "\" type=\"" + dataType + "\" />\n";
        }
        return "            <column name=\"" + name + "\" type=\"" + dataType + "\">\n                <constraints" + nullability + primaryKey + " />\n            </column>\n";
    }

    private static String getDataType(DataTypeProperty dataTypeProperty) {
        LiquibaseSchemaGeneratorDataTypePropertyVisitor visitor = new LiquibaseSchemaGeneratorDataTypePropertyVisitor();
        dataTypeProperty.visit((DataTypePropertyVisitor)visitor);
        return visitor.getDataTypeSourceCode();
    }

    private static String getNullability(DataTypeProperty dataTypeProperty) {
        return dataTypeProperty.isTemporalInstant() || dataTypeProperty.isRequired() ? " nullable=\"false\"" : "";
    }

    private static String getPrimaryKey(DataTypeProperty dataTypeProperty, String tableName) {
        if (!dataTypeProperty.isKey() && !dataTypeProperty.isTo()) {
            return "";
        }
        return " primaryKey=\"true\" primaryKeyName=\"" + tableName + "_PK\"";
    }
}

