/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.liquibase.schema;

import cool.klass.generator.liquibase.schema.ForeignKeyGenerator;
import cool.klass.generator.liquibase.schema.IndexGenerator;
import cool.klass.generator.liquibase.schema.TableGenerator;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.Klass;
import java.io.Serializable;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.ImmutableList;

public final class SchemaGenerator {
    private SchemaGenerator() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static String getSourceCode(DomainModel domainModel, String fullyQualifiedPackage) {
        ImmutableList classes = domainModel.getClasses().select((Predicate & Serializable)each -> each.getPackageName().equals(fullyQualifiedPackage));
        ImmutableList tableSourceCodes = classes.collectWithIndex(SchemaGenerator::getTableSourceCode);
        ImmutableList foreignKeySourceCodes = classes.collectWithIndex(SchemaGenerator::getForeignKeySourceCode);
        ImmutableList indexSourceCodes = classes.collectWithIndex(SchemaGenerator::getIndexSourceCode);
        return "<?xml version=\"1.1\" encoding=\"UTF-8\" standalone=\"no\"?>\n<!--Generated by cool.klass.generator.liquibase.schema.SchemaGenerator -->\n<databaseChangeLog xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\"\n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.10.xsd\"\n        objectQuotingStrategy=\"QUOTE_ALL_OBJECTS\">\n\n" + tableSourceCodes.makeString("") + foreignKeySourceCodes.makeString("") + indexSourceCodes.makeString("") + "</databaseChangeLog>\n";
    }

    public static String getTableSourceCode(Klass klass, int index) {
        return TableGenerator.getTable(klass, index + 1);
    }

    public static String getIndexSourceCode(Klass klass, int index) {
        return IndexGenerator.getIndex(klass, index + 1);
    }

    public static String getForeignKeySourceCode(Klass klass, int index) {
        return ForeignKeyGenerator.getForeignKeys(klass, index + 1).orElse("");
    }
}

