/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.liquibase.schema;

import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.property.EnumerationProperty;
import cool.klass.model.meta.domain.api.property.PrimitiveProperty;
import cool.klass.model.meta.domain.api.property.validation.NumericPropertyValidation;
import cool.klass.model.meta.domain.api.visitor.DataTypePropertyVisitor;
import java.util.Objects;

public class LiquibaseSchemaGeneratorDataTypePropertyVisitor
implements DataTypePropertyVisitor {
    private String dataTypeSourceCode;

    public String getDataTypeSourceCode() {
        Objects.requireNonNull(this.dataTypeSourceCode);
        return this.dataTypeSourceCode;
    }

    private void handleDataTypeProperty(DataTypeProperty dataTypeProperty) {
        int maxLength = dataTypeProperty.getMaxLengthPropertyValidation().map(NumericPropertyValidation::getNumber).orElse(255);
        this.dataTypeSourceCode = "varchar(" + maxLength + ")";
    }

    public void visitEnumerationProperty(EnumerationProperty enumerationProperty) {
        this.handleDataTypeProperty((DataTypeProperty)enumerationProperty);
    }

    public void visitString(PrimitiveProperty primitiveProperty) {
        this.handleDataTypeProperty((DataTypeProperty)primitiveProperty);
    }

    public void visitInteger(PrimitiveProperty primitiveProperty) {
        this.dataTypeSourceCode = "int";
    }

    public void visitLong(PrimitiveProperty primitiveProperty) {
        this.dataTypeSourceCode = "bigint";
    }

    public void visitDouble(PrimitiveProperty primitiveProperty) {
        this.dataTypeSourceCode = "float8";
    }

    public void visitFloat(PrimitiveProperty primitiveProperty) {
        this.dataTypeSourceCode = "float4";
    }

    public void visitBoolean(PrimitiveProperty primitiveProperty) {
        this.dataTypeSourceCode = "boolean";
    }

    public void visitInstant(PrimitiveProperty primitiveProperty) {
        this.dataTypeSourceCode = "timestamp";
    }

    public void visitLocalDate(PrimitiveProperty primitiveProperty) {
        this.dataTypeSourceCode = "date";
    }

    public void visitTemporalInstant(PrimitiveProperty primitiveProperty) {
        this.dataTypeSourceCode = "timestamp";
    }

    public void visitTemporalRange(PrimitiveProperty primitiveProperty) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".visitTemporalRange() not implemented yet");
    }
}

