/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.reladomo.plugin;

import cool.klass.generator.plugin.AbstractGenerateMojo;
import cool.klass.generator.reladomo.classlist.ReladomoClassListGenerator;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.source.DomainModelWithSourceCode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-reladomo-class-list", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class GenerateReladomoClassListMojo
extends AbstractGenerateMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-resources/reladomo")
    private File outputDirectory;
    @Parameter(property="outputFilename", required=true, defaultValue="ReladomoClassList.xml")
    private String outputFilename;

    public void execute() throws MojoExecutionException {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        DomainModelWithSourceCode domainModel = this.getDomainModel();
        Path outputPath = this.outputDirectory.toPath();
        Path path = outputPath.resolve(this.outputFilename);
        try {
            ReladomoClassListGenerator reladomoClassListGenerator = new ReladomoClassListGenerator((DomainModel)domainModel);
            reladomoClassListGenerator.writeClassListFile(path);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        Resource resource = new Resource();
        resource.setDirectory(this.outputDirectory.getAbsolutePath());
        resource.setTargetPath("reladomo");
        this.mavenProject.addResource(resource);
    }
}

