/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.reladomo.plugin;

import cool.klass.generator.plugin.AbstractGenerateMojo;
import cool.klass.generator.reladomo.interfacefile.ReladomoInterfaceFileGenerator;
import cool.klass.generator.reladomo.objectfile.ReladomoObjectFileGenerator;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.source.DomainModelWithSourceCode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-reladomo-object-files", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class GenerateReladomoObjectFilesMojo
extends AbstractGenerateMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-resources/reladomo")
    private File outputDirectory;

    public void execute() throws MojoExecutionException {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        Path outputPath = this.outputDirectory.toPath();
        DomainModelWithSourceCode domainModel = this.getDomainModel();
        ReladomoObjectFileGenerator reladomoObjectFileGenerator = new ReladomoObjectFileGenerator((DomainModel)domainModel);
        ReladomoInterfaceFileGenerator reladomoInterfaceFileGenerator = new ReladomoInterfaceFileGenerator((DomainModel)domainModel);
        try {
            reladomoObjectFileGenerator.writeObjectFiles(outputPath);
            reladomoInterfaceFileGenerator.writeObjectFiles(outputPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        Resource resource = new Resource();
        resource.setDirectory(this.outputDirectory.getAbsolutePath());
        resource.setTargetPath("reladomo");
        this.mavenProject.addResource(resource);
    }
}

