/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.reladomo;

import cool.klass.generator.reladomo.ExpressionValueToRelationshipVisitor;
import cool.klass.generator.reladomo.OperatorToRelationshipVisitor;
import cool.klass.model.meta.domain.api.criteria.AllCriteria;
import cool.klass.model.meta.domain.api.criteria.AndCriteria;
import cool.klass.model.meta.domain.api.criteria.CriteriaVisitor;
import cool.klass.model.meta.domain.api.criteria.EdgePointCriteria;
import cool.klass.model.meta.domain.api.criteria.OperatorCriteria;
import cool.klass.model.meta.domain.api.criteria.OrCriteria;
import cool.klass.model.meta.domain.api.operator.Operator;
import cool.klass.model.meta.domain.api.operator.OperatorVisitor;
import cool.klass.model.meta.domain.api.value.ExpressionValue;
import cool.klass.model.meta.domain.api.value.ExpressionValueVisitor;
import cool.klass.model.meta.domain.api.value.literal.NullLiteral;
import java.util.Objects;
import javax.annotation.Nonnull;

public class CriteriaToRelationshipVisitor
implements CriteriaVisitor {
    @Nonnull
    private final StringBuilder stringBuilder;
    private final boolean reverse;

    public CriteriaToRelationshipVisitor(@Nonnull StringBuilder stringBuilder, boolean reverse) {
        this.stringBuilder = Objects.requireNonNull(stringBuilder);
        this.reverse = reverse;
    }

    public void visitAll(@Nonnull AllCriteria allCriteria) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".visitAll() not implemented yet");
    }

    public void visitAnd(@Nonnull AndCriteria andCriteria) {
        andCriteria.getLeft().visit((CriteriaVisitor)this);
        this.stringBuilder.append(" and ");
        andCriteria.getRight().visit((CriteriaVisitor)this);
    }

    public void visitOr(@Nonnull OrCriteria orCriteria) {
        orCriteria.getLeft().visit((CriteriaVisitor)this);
        this.stringBuilder.append(" or ");
        orCriteria.getRight().visit((CriteriaVisitor)this);
    }

    public void visitOperator(@Nonnull OperatorCriteria operatorCriteria) {
        Operator operator = operatorCriteria.getOperator();
        ExpressionValue sourceValue = operatorCriteria.getSourceValue();
        ExpressionValue targetValue = operatorCriteria.getTargetValue();
        if (targetValue instanceof NullLiteral) {
            sourceValue.visit((ExpressionValueVisitor)new ExpressionValueToRelationshipVisitor(this.stringBuilder, this.reverse));
            String reladomoNullOperator = this.getReladomoNullOperator(operator);
            this.stringBuilder.append(" ");
            this.stringBuilder.append(reladomoNullOperator);
            return;
        }
        sourceValue.visit((ExpressionValueVisitor)new ExpressionValueToRelationshipVisitor(this.stringBuilder, this.reverse));
        operator.visit((OperatorVisitor)new OperatorToRelationshipVisitor(this.stringBuilder));
        targetValue.visit((ExpressionValueVisitor)new ExpressionValueToRelationshipVisitor(this.stringBuilder, this.reverse));
    }

    @Nonnull
    private String getReladomoNullOperator(@Nonnull Operator operator) {
        String operatorText;
        return switch (operatorText = operator.getOperatorText()) {
            case "==" -> "is null";
            case "!=" -> "is not null";
            default -> throw new AssertionError();
        };
    }

    public void visitEdgePoint(@Nonnull EdgePointCriteria edgePointCriteria) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".visitEdgePoint() not implemented yet");
    }
}

