/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.reladomo.objectfile;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.gs.fw.common.mithra.generator.metamodel.AsOfAttributePureType;
import com.gs.fw.common.mithra.generator.metamodel.AsOfAttributeType;
import com.gs.fw.common.mithra.generator.metamodel.AttributePureType;
import com.gs.fw.common.mithra.generator.metamodel.AttributeType;
import com.gs.fw.common.mithra.generator.metamodel.MithraCommonObjectType;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorMarshaller;
import com.gs.fw.common.mithra.generator.metamodel.MithraObject;
import com.gs.fw.common.mithra.generator.metamodel.MithraPureObject;
import com.gs.fw.common.mithra.generator.metamodel.ObjectType;
import com.gs.fw.common.mithra.generator.metamodel.RelationshipType;
import com.gs.fw.common.mithra.generator.metamodel.TimezoneConversionType;
import cool.klass.generator.reladomo.AbstractReladomoGenerator;
import cool.klass.generator.reladomo.CriteriaToRelationshipVisitor;
import cool.klass.generator.reladomo.objectfile.AttributeTypeVisitor;
import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.Interface;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.PrimitiveType;
import cool.klass.model.meta.domain.api.criteria.Criteria;
import cool.klass.model.meta.domain.api.criteria.CriteriaVisitor;
import cool.klass.model.meta.domain.api.order.OrderBy;
import cool.klass.model.meta.domain.api.order.OrderByDirection;
import cool.klass.model.meta.domain.api.order.OrderByMemberReferencePath;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.property.EnumerationProperty;
import cool.klass.model.meta.domain.api.property.PrimitiveProperty;
import cool.klass.model.meta.domain.api.property.validation.NumericPropertyValidation;
import cool.klass.model.meta.domain.api.value.ThisMemberReferencePath;
import cool.klass.model.meta.domain.api.visitor.PrimitiveTypeVisitor;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.list.ImmutableListFactory;
import org.eclipse.collections.api.list.ImmutableList;

public class ReladomoObjectFileGenerator
extends AbstractReladomoGenerator {
    public static final Converter<String, String> TO_LOWER = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);
    public static final Converter<String, String> TABLE_NAME_CONVERTER = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE);
    public static final Converter<String, String> COLUMN_NAME_CONVERTER = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE);

    public ReladomoObjectFileGenerator(@Nonnull DomainModel domainModel) {
        super(domainModel);
    }

    public void writeObjectFiles(@Nonnull Path outputPath) throws IOException {
        for (Klass klass : this.domainModel.getClasses()) {
            this.writeObjectFile(outputPath, klass);
        }
    }

    private void writeObjectFile(@Nonnull Path outputPath, @Nonnull Klass klass) throws IOException {
        MithraGeneratorMarshaller mithraGeneratorMarshaller = new MithraGeneratorMarshaller();
        mithraGeneratorMarshaller.setIndent(true);
        StringBuilder stringBuilder = new StringBuilder();
        this.convertAndMarshall(klass, mithraGeneratorMarshaller, stringBuilder);
        String xmlString = this.sanitizeXmlString(stringBuilder);
        Path fullPath = outputPath.resolve(klass.getName() + ".xml");
        this.printStringToFile(fullPath, xmlString);
    }

    private void convertAndMarshall(@Nonnull Klass klass, @Nonnull MithraGeneratorMarshaller mithraGeneratorMarshaller, StringBuilder stringBuilder) throws IOException {
        if (klass.isTransient()) {
            MithraPureObject mithraPureObject = this.convertToMithraPureObject(klass);
            mithraGeneratorMarshaller.marshall((Appendable)stringBuilder, mithraPureObject);
        } else {
            MithraObject mithraObject = this.convertToMithraObject(klass);
            mithraGeneratorMarshaller.marshall((Appendable)stringBuilder, mithraObject);
        }
    }

    @Nonnull
    private MithraPureObject convertToMithraPureObject(@Nonnull Klass klass) {
        MithraPureObject mithraPureObject = new MithraPureObject();
        this.convertCommonObject(klass, (MithraCommonObjectType)mithraPureObject);
        ImmutableList asOfAttributeTypes = klass.getDataTypeProperties().select(DataTypeProperty::isTemporalRange).collect(this::convertToAsOfAttributePureType);
        ImmutableList attributeTypes = this.getDataTypeProperties(klass).collect((Function & Serializable)dataTypeProperty -> this.convertToAttributePureType(klass, (DataTypeProperty)dataTypeProperty));
        mithraPureObject.setAsOfAttributes(asOfAttributeTypes.castToList());
        mithraPureObject.setAttributes(attributeTypes.castToList());
        mithraPureObject.setRelationships(this.convertRelationships(klass));
        return mithraPureObject;
    }

    @Nonnull
    private MithraObject convertToMithraObject(@Nonnull Klass klass) {
        MithraObject mithraObject = new MithraObject();
        this.convertCommonObject(klass, (MithraCommonObjectType)mithraObject);
        mithraObject.setDefaultTable(ReladomoObjectFileGenerator.quote((String)TABLE_NAME_CONVERTER.convert((Object)klass.getName())));
        ImmutableList superInterfaceNames = klass.getInterfaces().collect(NamedElement::getName);
        mithraObject.setMithraInterfaces(superInterfaceNames.castToList());
        ImmutableList asOfAttributeTypes = klass.getDataTypeProperties().select(DataTypeProperty::isTemporalRange).collect(this::convertToAsOfAttributeType);
        ImmutableList attributeTypes = this.getDataTypeProperties(klass).reject(DataTypeProperty::isTemporal).reject(DataTypeProperty::isDerived).collect((Function & Serializable)dataTypeProperty -> this.convertToAttributeType(klass, (DataTypeProperty)dataTypeProperty));
        mithraObject.setAsOfAttributes(asOfAttributeTypes.castToList());
        mithraObject.setAttributes(attributeTypes.castToList());
        mithraObject.setRelationships(this.convertRelationships(klass));
        return mithraObject;
    }

    private ImmutableList<DataTypeProperty> getDataTypeProperties(@Nonnull Klass klass) {
        ImmutableList superClassPropertyNames = klass.getSuperClass().map(Classifier::getDataTypeProperties).orElseGet(() -> ((ImmutableListFactory)Lists.immutable).empty()).collect(NamedElement::getName);
        return klass.getDataTypeProperties().select((Predicate & Serializable)each -> each.isKey() || !superClassPropertyNames.contains((Object)each.getName()));
    }

    private void convertCommonObject(@Nonnull Klass klass, @Nonnull MithraCommonObjectType mithraCommonObject) {
        ObjectType objectType = new ObjectType();
        objectType.with("transactional", (Object)mithraCommonObject);
        mithraCommonObject.setObjectType(objectType);
        mithraCommonObject.setPackageName(klass.getPackageName());
        mithraCommonObject.setClassName(klass.getName());
        mithraCommonObject.setInitializePrimitivesToNull(true);
    }

    private List<RelationshipType> convertRelationships(@Nonnull Klass klass) {
        ImmutableList associationEnds = klass.getDeclaredAssociationEnds();
        for (AssociationEnd associationEnd : associationEnds) {
            int count = 0;
            if (this.isForwardRelationship(associationEnd)) {
                ++count;
            }
            if (this.isReverseRelationship(associationEnd)) {
                ++count;
            }
            if (this.isForwardRelationship(associationEnd.getOpposite())) {
                ++count;
            }
            if (this.isReverseRelationship(associationEnd.getOpposite())) {
                ++count;
            }
            if (count != 1) {
                throw new AssertionError((Object)("Count: " + count + " " + String.valueOf(associationEnd)));
            }
        }
        ImmutableList forward = associationEnds.select(this::isForwardRelationship);
        ImmutableList reverse = associationEnds.select(this::isReverseRelationship);
        ImmutableList relationshipTypes = forward.collectWith(this::convertRelationship, (Object)false);
        ImmutableList reverseAbstractRelationshipTypes = reverse.collectWith(this::convertRelationship, (Object)true);
        ImmutableList subClassRelationships = klass.getSubClasses().collect(this::convertSubClassRelationship);
        return relationshipTypes.newWithAll((Iterable)reverseAbstractRelationshipTypes).newWithAll((Iterable)subClassRelationships).castToList();
    }

    private boolean isForwardRelationship(AssociationEnd associationEnd) {
        return this.isForwardDeclared(associationEnd) && !this.mustBeOnResultType(associationEnd.getOpposite());
    }

    private boolean isReverseRelationship(AssociationEnd associationEnd) {
        return this.isReverseDeclared(associationEnd) && this.mustBeOnResultType(associationEnd);
    }

    private boolean isForwardDeclared(AssociationEnd associationEnd) {
        return associationEnd == associationEnd.getOwningAssociation().getTargetAssociationEnd();
    }

    private boolean isReverseDeclared(AssociationEnd associationEnd) {
        return associationEnd == associationEnd.getOwningAssociation().getSourceAssociationEnd();
    }

    private boolean mustBeOnResultType(AssociationEnd associationEnd) {
        return associationEnd.isOwned();
    }

    @Nonnull
    private RelationshipType convertRelationship(@Nonnull AssociationEnd associationEnd, boolean reverse) {
        if (this.isForwardRelationship(associationEnd) && this.isReverseRelationship(associationEnd)) {
            throw new AssertionError(associationEnd);
        }
        AssociationEnd opposite = associationEnd.getOpposite();
        RelationshipType relationshipType = new RelationshipType();
        relationshipType.setName(associationEnd.getName());
        relationshipType.setReverseRelationshipName(opposite.getName());
        relationshipType.setCardinality(this.getCardinality(associationEnd, opposite));
        relationshipType.setRelatedIsDependent(associationEnd.isOwned());
        relationshipType.setRelatedObject(associationEnd.getType().getName());
        relationshipType.setOrderBy(this.getOrderBy(associationEnd));
        String relationshipString = this.getRelationshipString(associationEnd.getOwningAssociation().getCriteria(), reverse);
        relationshipType._setValue(relationshipString);
        return relationshipType;
    }

    private RelationshipType convertSubClassRelationship(Klass subClass) {
        Klass superClass = (Klass)subClass.getSuperClass().get();
        RelationshipType relationshipType = new RelationshipType();
        relationshipType.setName((String)TO_LOWER.convert((Object)subClass.getName()) + "SubClass");
        relationshipType.setReverseRelationshipName((String)TO_LOWER.convert((Object)superClass.getName()) + "SuperClass");
        relationshipType.setCardinality(this.getCardinalityType("one-to-one"));
        relationshipType.setRelatedIsDependent(true);
        relationshipType.setRelatedObject(subClass.getName());
        String relationshipString = superClass.getKeyProperties().collectWith(this::getRelationshipClause, (Object)subClass).makeString(" and ");
        relationshipType._setValue(relationshipString);
        return relationshipType;
    }

    private String getRelationshipClause(DataTypeProperty keyProperty, Klass subClass) {
        return "this.%s = %s.%s".formatted(keyProperty.getName(), subClass.getName(), keyProperty.getName());
    }

    @Nonnull
    private String getRelationshipString(@Nonnull Criteria criteria, boolean reverse) {
        StringBuilder stringBuilder = new StringBuilder();
        CriteriaToRelationshipVisitor visitor = new CriteriaToRelationshipVisitor(stringBuilder, reverse);
        criteria.visit((CriteriaVisitor)visitor);
        return stringBuilder.toString();
    }

    @Nullable
    private String getOrderBy(@Nonnull AssociationEnd associationEnd) {
        ImmutableList orderByStrings = associationEnd.getOrderBy().map(OrderBy::getOrderByMemberReferencePaths).orElseGet(() -> ((ImmutableListFactory)Lists.immutable).empty()).selectWith(this::isConvertibleToOrderBy, (Object)associationEnd.getType()).collect(this::convertOrderByMemberReferencePath);
        return orderByStrings.isEmpty() ? null : orderByStrings.makeString();
    }

    private boolean isConvertibleToOrderBy(@Nonnull OrderByMemberReferencePath orderByMemberReferencePath, Klass klass) {
        ThisMemberReferencePath thisMemberReferencePath = orderByMemberReferencePath.getThisMemberReferencePath();
        DataTypeProperty property = thisMemberReferencePath.getProperty();
        if (property.isDerived()) {
            return false;
        }
        if (orderByMemberReferencePath.getThisMemberReferencePath().getAssociationEnds().notEmpty()) {
            return false;
        }
        if (property.getOwningClassifier() == klass) {
            return true;
        }
        Classifier classifier = property.getOwningClassifier();
        if (classifier instanceof Interface) {
            Interface anInterface = (Interface)classifier;
            if (klass.getInterfaces().contains((Object)anInterface)) {
                return true;
            }
        }
        return false;
    }

    private String convertOrderByMemberReferencePath(@Nonnull OrderByMemberReferencePath orderByMemberReferencePath) {
        DataTypeProperty property = orderByMemberReferencePath.getThisMemberReferencePath().getProperty();
        String propertyName = property.getName();
        String orderByDirectionString = this.getOrderByDirectionString(orderByMemberReferencePath);
        return String.format("%s %s", propertyName, orderByDirectionString);
    }

    @Nonnull
    private String getOrderByDirectionString(@Nonnull OrderByMemberReferencePath orderByMemberReferencePath) {
        OrderByDirection orderByDirection = orderByMemberReferencePath.getOrderByDirectionDeclaration().getOrderByDirection();
        return switch (orderByDirection) {
            case OrderByDirection.ASCENDING -> "asc";
            case OrderByDirection.DESCENDING -> "desc";
            default -> throw new AssertionError();
        };
    }

    @Nonnull
    private AsOfAttributeType convertToAsOfAttributeType(@Nonnull DataTypeProperty dataTypeProperty) {
        AsOfAttributeType asOfAttributeType = new AsOfAttributeType();
        this.convertToAsOfAttributeType(dataTypeProperty, (AsOfAttributePureType)asOfAttributeType);
        return asOfAttributeType;
    }

    private void convertToAsOfAttributeType(@Nonnull DataTypeProperty dataTypeProperty, @Nonnull AsOfAttributePureType asOfAttributeType) {
        String propertyName = dataTypeProperty.getName();
        String fromName = propertyName + "From";
        String toName = propertyName + "To";
        String fromColumnName = ReladomoObjectFileGenerator.quote((String)COLUMN_NAME_CONVERTER.convert((Object)fromName));
        String toColumnName = ReladomoObjectFileGenerator.quote((String)COLUMN_NAME_CONVERTER.convert((Object)toName));
        asOfAttributeType.setName(propertyName);
        asOfAttributeType.setFromColumnName(fromColumnName);
        asOfAttributeType.setToColumnName(toColumnName);
        asOfAttributeType.setToIsInclusive(false);
        asOfAttributeType.setInfinityDate("[com.gs.fw.common.mithra.util.DefaultInfinityTimestamp.getDefaultInfinity()]");
        asOfAttributeType.setInfinityIsNull(false);
        asOfAttributeType.setFutureExpiringRowsExist(true);
        asOfAttributeType.setFinalGetter(true);
        TimezoneConversionType timezoneConversion = new TimezoneConversionType();
        timezoneConversion.with("convert-to-utc", (Object)asOfAttributeType);
        asOfAttributeType.setTimezoneConversion(timezoneConversion);
        if (propertyName.equals("valid")) {
            asOfAttributeType.setIsProcessingDate(false);
        } else if (propertyName.equals("system")) {
            asOfAttributeType.setDefaultIfNotSpecified("[com.gs.fw.common.mithra.util.DefaultInfinityTimestamp.getDefaultInfinity()]");
            asOfAttributeType.setIsProcessingDate(true);
        } else {
            throw new AssertionError((Object)propertyName);
        }
    }

    @Nonnull
    private AsOfAttributePureType convertToAsOfAttributePureType(@Nonnull DataTypeProperty dataTypeProperty) {
        AsOfAttributePureType asOfAttributeType = new AsOfAttributePureType();
        this.convertToAsOfAttributeType(dataTypeProperty, asOfAttributeType);
        return asOfAttributeType;
    }

    @Nonnull
    private AttributeType convertToAttributeType(@Nonnull Klass owningClass, @Nonnull DataTypeProperty dataTypeProperty) {
        AttributeType attributeType = new AttributeType();
        this.convertToAttributeType(owningClass, dataTypeProperty, (AttributePureType)attributeType);
        return attributeType;
    }

    private void convertToAttributeType(@Nonnull Klass owningClass, @Nonnull DataTypeProperty dataTypeProperty, @Nonnull AttributePureType attributeType) {
        String propertyName = dataTypeProperty.getName();
        attributeType.setName(propertyName);
        attributeType.setColumnName(ReladomoObjectFileGenerator.quote((String)COLUMN_NAME_CONVERTER.convert((Object)propertyName)));
        attributeType.setPrimaryKey(dataTypeProperty.isKey());
        attributeType.setNullable(dataTypeProperty.isOptional());
        if (dataTypeProperty.isKey() || dataTypeProperty.isFinal()) {
            attributeType.setFinalGetter(true);
        }
        this.handleType(owningClass, dataTypeProperty, attributeType);
    }

    private void handleType(@Nonnull Klass owningClass, @Nonnull DataTypeProperty dataTypeProperty, @Nonnull AttributePureType attributeType) {
        if (dataTypeProperty instanceof EnumerationProperty) {
            attributeType.setJavaType("String");
            attributeType.setTrim(false);
            dataTypeProperty.getMaxLengthPropertyValidation().map(NumericPropertyValidation::getNumber).ifPresent(arg_0 -> ((AttributePureType)attributeType).setMaxLength(arg_0));
        }
        if (dataTypeProperty instanceof PrimitiveProperty) {
            PrimitiveProperty primitiveProperty = (PrimitiveProperty)dataTypeProperty;
            PrimitiveType primitiveType = primitiveProperty.getType();
            primitiveType.visit((PrimitiveTypeVisitor)new AttributeTypeVisitor(owningClass, primitiveProperty, attributeType));
        }
    }

    @Nonnull
    private AttributePureType convertToAttributePureType(@Nonnull Klass owningClass, @Nonnull DataTypeProperty dataTypeProperty) {
        AttributePureType attributeType = new AttributePureType();
        this.convertToAttributeType(owningClass, dataTypeProperty, attributeType);
        return attributeType;
    }

    private static String quote(String string) {
        return "\\\"" + string + "\\\"";
    }
}

