/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.reladomo.mergehook;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.PackageableElement;
import cool.klass.model.meta.domain.api.PrimitiveType;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ReladomoMergeHookGenerator {
    private static final Converter<String, String> LOWER_CAMEL_TO_UPPER_CAMEL = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
    @Nonnull
    private final DomainModel domainModel;

    public ReladomoMergeHookGenerator(@Nonnull DomainModel domainModel) {
        this.domainModel = Objects.requireNonNull(domainModel);
    }

    public void writeMergeHookFiles(@Nonnull Path outputPath) {
        this.domainModel.getClasses().reject(Classifier::isAbstract).select(Klass::isVersioned).forEachWith(this::writeMergeHookFile, (Object)outputPath);
    }

    private void writeMergeHookFile(@Nonnull Klass klass, @Nonnull Path outputPath) {
        Path mergeHookOutputPath = this.getMergeHookOutputPath(outputPath, (PackageableElement)klass);
        String classSourceCode = this.getMergeHookSourceCode(klass);
        this.printStringToFile(mergeHookOutputPath, classSourceCode);
    }

    @Nonnull
    private Path getMergeHookOutputPath(@Nonnull Path outputPath, @Nonnull PackageableElement packageableElement) {
        String packageRelativePath = packageableElement.getPackageName().replaceAll("\\.", "/");
        Path mergeHookDirectory = outputPath.resolve(packageRelativePath).resolve("reladomo").resolve("merge").resolve("hook");
        mergeHookDirectory.toFile().mkdirs();
        String fileName = packageableElement.getName() + "MergeHook.java";
        return mergeHookDirectory.resolve(fileName);
    }

    private void printStringToFile(@Nonnull Path path, String contents) {
        try (PrintStream printStream = new PrintStream(new FileOutputStream(path.toFile()));){
            printStream.print(contents);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    private String getMergeHookSourceCode(@Nonnull Klass klass) {
        Klass versionClass = ((AssociationEnd)klass.getVersionProperty().get()).getType();
        String setKeyPropertiesSourceCode = klass.getKeyProperties().collect(this::getKeyPropertySourceCode).makeString("");
        String setAuditPropertiesOnCreateSourceCode = klass.isAudited() ? "        version.setCreatedOn(newObject.getCreatedOn());\n        version.setCreatedById(newObject.getCreatedById());\n        version.setLastUpdatedById(newObject.getLastUpdatedById());\n" : "";
        String setAuditPropertiesOnUpdateSourceCode = klass.isAudited() ? "        existingVersion.setLastUpdatedById(incoming.getLastUpdatedById());\n" : "";
        String sourceCode = "package " + klass.getPackageName() + ".reladomo.merge.hook;\n\nimport javax.annotation.*;\n\nimport " + klass.getFullyQualifiedName() + ";\nimport " + versionClass.getFullyQualifiedName() + ";\nimport com.gs.fw.common.mithra.list.merge.MergeBuffer;\nimport com.gs.fw.common.mithra.list.merge.MergeHook;\n\n/**\n * Auto-generated by {@link " + this.getClass().getCanonicalName() + "}\n */\npublic class " + klass.getName() + "MergeHook extends MergeHook<" + klass.getName() + ">\n{\n    @Override\n    public InsertInstruction beforeInsertOfNew(@Nonnull " + klass.getName() + " newObject)\n    {\n        " + versionClass.getName() + " version = new " + versionClass.getName() + "();\n        version.setNumber(1);\n" + setKeyPropertiesSourceCode + setAuditPropertiesOnCreateSourceCode + "        version.insert();\n        return super.beforeInsertOfNew(newObject);\n    }\n\n    @Override\n    public UpdateInstruction matchedWithDifferenceBeforeAttributeCopy(\n            @Nonnull " + klass.getName() + " existing,\n            " + klass.getName() + " incoming)\n    {\n        " + versionClass.getName() + " existingVersion = existing.getVersion();\n        existingVersion.setNumber(existingVersion.getNumber() + 1);\n" + setAuditPropertiesOnUpdateSourceCode + "        return super.matchedWithDifferenceBeforeAttributeCopy(existing, incoming);\n    }\n\n    @Override\n    public DeleteOrTerminateInstruction beforeDeleteOrTerminate(\n            @Nonnull " + klass.getName() + " existing,\n            MergeBuffer<" + klass.getName() + "> mergeBuffer)\n    {\n        existing.getVersion().terminate();\n        return super.beforeDeleteOrTerminate(existing, mergeBuffer);\n    }\n}\n\n";
        return sourceCode;
    }

    private String getKeyPropertySourceCode(DataTypeProperty keyProperty) {
        String name = (String)LOWER_CAMEL_TO_UPPER_CAMEL.convert((Object)keyProperty.getName());
        String prefix = keyProperty.getType() == PrimitiveType.BOOLEAN ? "is" : "get";
        return "        version.set" + name + "(newObject." + prefix + name + "());\n";
    }
}

