/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.reladomo.objectfile;

import com.gs.fw.common.mithra.generator.metamodel.AttributePureType;
import com.gs.fw.common.mithra.generator.metamodel.PrimaryKeyGeneratorStrategyType;
import com.gs.fw.common.mithra.generator.metamodel.SimulatedSequenceType;
import com.gs.fw.common.mithra.generator.metamodel.TimezoneConversionType;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.property.PrimitiveProperty;
import cool.klass.model.meta.domain.api.property.validation.NumericPropertyValidation;
import cool.klass.model.meta.domain.api.visitor.PrimitiveTypeVisitor;
import io.liftwizard.reladomo.simseq.ObjectSequenceObjectFactory;
import java.util.Objects;

class AttributeTypeVisitor
implements PrimitiveTypeVisitor {
    private final Klass owningClass;
    private final PrimitiveProperty primitiveProperty;
    private final AttributePureType attributeType;

    AttributeTypeVisitor(Klass owningClass, PrimitiveProperty primitiveProperty, AttributePureType attributeType) {
        this.owningClass = Objects.requireNonNull(owningClass);
        this.primitiveProperty = Objects.requireNonNull(primitiveProperty);
        this.attributeType = Objects.requireNonNull(attributeType);
    }

    public void visitString() {
        this.attributeType.setJavaType("String");
        this.attributeType.setTrim(false);
        this.primitiveProperty.getMaxLengthPropertyValidation().map(NumericPropertyValidation::getNumber).ifPresent(arg_0 -> ((AttributePureType)this.attributeType).setMaxLength(arg_0));
    }

    public void visitInteger() {
        this.attributeType.setJavaType("int");
    }

    public void visitLong() {
        this.attributeType.setJavaType("long");
        if (this.primitiveProperty.isID() && (this.owningClass == this.primitiveProperty.getOwningClassifier() || this.owningClass.getSuperClass().isEmpty())) {
            PrimaryKeyGeneratorStrategyType primaryKeyGeneratorStrategyType = new PrimaryKeyGeneratorStrategyType();
            primaryKeyGeneratorStrategyType.with("SimulatedSequence", (Object)this.attributeType);
            this.attributeType.setPrimaryKeyGeneratorStrategy(primaryKeyGeneratorStrategyType);
            SimulatedSequenceType simulatedSequence = new SimulatedSequenceType();
            simulatedSequence.setSequenceName(this.owningClass.getName());
            simulatedSequence.setSequenceObjectFactoryName(ObjectSequenceObjectFactory.class.getCanonicalName());
            simulatedSequence.setHasSourceAttribute(false);
            simulatedSequence.setBatchSize(10);
            simulatedSequence.setInitialValue(1);
            simulatedSequence.setIncrementSize(1);
            this.attributeType.setSimulatedSequence(simulatedSequence);
        }
    }

    public void visitDouble() {
        this.attributeType.setJavaType("double");
    }

    public void visitFloat() {
        this.attributeType.setJavaType("float");
    }

    public void visitBoolean() {
        this.attributeType.setJavaType("boolean");
    }

    public void visitInstant() {
        this.attributeType.setJavaType("Timestamp");
        TimezoneConversionType timezoneConversion = new TimezoneConversionType();
        timezoneConversion.with("convert-to-utc", (Object)this.attributeType);
        this.attributeType.setTimezoneConversion(timezoneConversion);
    }

    public void visitLocalDate() {
        this.attributeType.setJavaType("Date");
    }

    public void visitTemporalInstant() {
        throw new AssertionError();
    }

    public void visitTemporalRange() {
        throw new AssertionError();
    }
}

