/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.reladomo.runtimeconfig;

import com.gs.fw.common.mithra.mithraruntime.CacheType;
import com.gs.fw.common.mithra.mithraruntime.ConnectionManagerType;
import com.gs.fw.common.mithra.mithraruntime.MithraObjectConfigurationType;
import com.gs.fw.common.mithra.mithraruntime.MithraPureObjectConfigurationType;
import com.gs.fw.common.mithra.mithraruntime.MithraRuntime;
import com.gs.fw.common.mithra.mithraruntime.MithraRuntimeMarshaller;
import com.gs.fw.common.mithra.mithraruntime.PropertyType;
import com.gs.fw.common.mithra.mithraruntime.PureObjectsType;
import cool.klass.generator.reladomo.AbstractReladomoGenerator;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.PackageableElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.impl.factory.Lists;

public class ReladomoRuntimeConfigurationGenerator
extends AbstractReladomoGenerator {
    @Nonnull
    private final String connectionManagerClassName;
    @Nullable
    private final String connectionManagerName;
    @Nonnull
    private final String rootPackageName;
    @Nonnull
    private final CacheType cacheType;

    public ReladomoRuntimeConfigurationGenerator(@Nonnull DomainModel domainModel, @Nonnull String connectionManagerClassName, @Nullable String connectionManagerName, @Nonnull String rootPackageName, @Nonnull String cacheType) {
        super(domainModel);
        this.connectionManagerClassName = Objects.requireNonNull(connectionManagerClassName);
        this.connectionManagerName = connectionManagerName;
        this.rootPackageName = Objects.requireNonNull(rootPackageName);
        this.cacheType = ReladomoRuntimeConfigurationGenerator.getCacheType(cacheType);
    }

    private static CacheType getCacheType(@Nonnull String cacheType) {
        return switch (cacheType) {
            case "partial" -> CacheType.PARTIAL;
            case "full" -> CacheType.FULL;
            case "none" -> CacheType.NONE;
            default -> {
                String message = String.format("Invalid cacheType. Expected one of [partial, full, none] but got: %s", cacheType);
                throw new RuntimeException(message);
            }
        };
    }

    public void writeRuntimeConfigFile(@Nonnull Path path) throws IOException {
        MithraRuntime mithraRuntime = this.getMithraRuntime();
        MithraRuntimeMarshaller mithraRuntimeMarshaller = new MithraRuntimeMarshaller();
        mithraRuntimeMarshaller.setIndent(true);
        StringBuilder stringBuilder = new StringBuilder();
        mithraRuntimeMarshaller.marshall((Appendable)stringBuilder, mithraRuntime);
        String xmlString = this.sanitizeXmlString(stringBuilder);
        this.printStringToFile(path, xmlString);
    }

    @Nonnull
    private MithraRuntime getMithraRuntime() {
        MithraRuntime mithraRuntime = new MithraRuntime();
        ConnectionManagerType connectionManager = this.getConnectionManager();
        mithraRuntime.setConnectionManagers((List)Lists.mutable.with((Object[])new ConnectionManagerType[]{connectionManager}));
        mithraRuntime.setPureObjects(this.getPureObjectsType());
        return mithraRuntime;
    }

    private ImmutableList<PropertyType> getPropertyTypes() {
        if (this.connectionManagerName == null) {
            return Lists.immutable.empty();
        }
        PropertyType propertyType = ReladomoRuntimeConfigurationGenerator.createPropertyType("connectionManagerName", this.connectionManagerName);
        return Lists.immutable.with((Object)propertyType);
    }

    @Nonnull
    private PureObjectsType getPureObjectsType() {
        PureObjectsType pureObjectsType = new PureObjectsType();
        pureObjectsType.setNotificationIdentifier(this.rootPackageName);
        pureObjectsType.setMithraObjectConfigurations(this.getMithraPureObjectConfigurationTypes().castToList());
        return pureObjectsType;
    }

    @Nonnull
    private static PropertyType createPropertyType(String name, String value) {
        PropertyType propertyType = new PropertyType();
        propertyType.setName(name);
        propertyType.setValue(value);
        return propertyType;
    }

    @Nonnull
    private ConnectionManagerType getConnectionManager() {
        ImmutableList<PropertyType> propertyTypes = this.getPropertyTypes();
        List properties = propertyTypes.castToList();
        ConnectionManagerType connectionManagerType = new ConnectionManagerType();
        connectionManagerType.setClassName(this.connectionManagerClassName);
        connectionManagerType.setProperties(properties);
        connectionManagerType.setMithraObjectConfigurations(this.getConnectionManagerObjectConfigurationTypes().castToList());
        connectionManagerType.setOffHeapReplicationExport(false);
        return connectionManagerType;
    }

    private ImmutableList<MithraPureObjectConfigurationType> getMithraPureObjectConfigurationTypes() {
        return this.domainModel.getClasses().select(Klass::isTransient).collect(PackageableElement::getFullyQualifiedName).collect(ReladomoRuntimeConfigurationGenerator::createMithraPureObjectConfigurationType);
    }

    private ImmutableList<MithraObjectConfigurationType> getConnectionManagerObjectConfigurationTypes() {
        ImmutableList<MithraObjectConfigurationType> objectConfigurationTypes = this.getObjectConfigurationTypes();
        MithraObjectConfigurationType objectSequenceObjectConfigurationType = ReladomoRuntimeConfigurationGenerator.createObjectSequenceObjectConfigurationType();
        return Lists.immutable.with((Object)objectSequenceObjectConfigurationType).newWithAll(objectConfigurationTypes);
    }

    private ImmutableList<MithraObjectConfigurationType> getObjectConfigurationTypes() {
        return this.domainModel.getClasses().reject(Klass::isTransient).collect(PackageableElement::getFullyQualifiedName).collectWith(ReladomoRuntimeConfigurationGenerator::createMithraObjectConfigurationType, (Object)this.cacheType);
    }

    @Nonnull
    private static MithraObjectConfigurationType createObjectSequenceObjectConfigurationType() {
        return ReladomoRuntimeConfigurationGenerator.createMithraObjectConfigurationType("io.liftwizard.reladomo.simseq.ObjectSequence", CacheType.NONE);
    }

    @Nonnull
    private static MithraObjectConfigurationType createMithraObjectConfigurationType(String fullyQualifiedClassName, CacheType cacheType) {
        MithraObjectConfigurationType mithraObjectConfigurationType = new MithraObjectConfigurationType();
        mithraObjectConfigurationType.setCacheType(cacheType);
        mithraObjectConfigurationType.setClassName(fullyQualifiedClassName);
        mithraObjectConfigurationType.setOffHeapReplicationExport(false);
        return mithraObjectConfigurationType;
    }

    @Nonnull
    private static MithraPureObjectConfigurationType createMithraPureObjectConfigurationType(String fullyQualifiedClassName) {
        MithraPureObjectConfigurationType mithraPureObjectConfigurationType = new MithraPureObjectConfigurationType();
        mithraPureObjectConfigurationType.setClassName(fullyQualifiedClassName);
        return mithraPureObjectConfigurationType;
    }
}

