/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.relational.schema;

import cool.klass.generator.relational.schema.DdlGenerator;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import java.io.Serializable;
import java.util.Optional;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.map.MutableOrderedMap;

public final class FkGenerator {
    private FkGenerator() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static Optional<String> getFk(Klass klass) {
        MutableOrderedMap foreignKeys = klass.getForeignKeys();
        if (foreignKeys.isEmpty()) {
            return Optional.empty();
        }
        if (klass.isTemporal()) {
            return Optional.empty();
        }
        String result = foreignKeys.keyValuesView().collect((Function & Serializable)keyValuePair -> FkGenerator.getFk(klass, (AssociationEnd)keyValuePair.getOne(), (MutableOrderedMap<DataTypeProperty, DataTypeProperty>)((MutableOrderedMap)keyValuePair.getTwo()))).makeString("");
        return Optional.of(result);
    }

    private static String getFk(Klass klass, AssociationEnd associationEnd, MutableOrderedMap<DataTypeProperty, DataTypeProperty> dataTypeProperties) {
        String tableName = (String)DdlGenerator.TABLE_NAME_CONVERTER.convert((Object)klass.getName());
        String constraintName = tableName + "_FK_" + (String)DdlGenerator.TABLE_NAME_CONVERTER.convert((Object)associationEnd.getName());
        String foreignKeyColumnNames = dataTypeProperties.keysView().collect(NamedElement::getName).collect(arg_0 -> DdlGenerator.COLUMN_NAME_CONVERTER.convert(arg_0)).makeString(", ");
        String referencedTableName = (String)DdlGenerator.TABLE_NAME_CONVERTER.convert((Object)associationEnd.getType().getName());
        String referencedKeyColumnNames = dataTypeProperties.valuesView().collect(NamedElement::getName).collect(arg_0 -> DdlGenerator.COLUMN_NAME_CONVERTER.convert(arg_0)).makeString(", ");
        String format = "alter table %s add constraint %s foreign key (\n    %s\n)\nreferences %s(\n    %s\n);\n\n";
        return format.formatted(tableName, constraintName, foreignKeyColumnNames, referencedTableName, referencedKeyColumnNames);
    }
}

