/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.relational.schema;

import cool.klass.generator.relational.schema.DdlGenerator;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.MutableOrderedMap;

public final class IdxGenerator {
    private IdxGenerator() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static String getIdx(Klass klass) {
        String tableName = DdlGenerator.getTableName(klass);
        String constraintName = tableName + "_PK";
        String primaryKeyColumnNames = IdxGenerator.getPrimaryKeyColumnNames(klass);
        String primaryKeyIndex = "alter table %s add constraint %s primary key (%s);\n\n".formatted(tableName, constraintName, primaryKeyColumnNames);
        MutableOrderedMap foreignKeyConstraints = klass.getForeignKeys();
        String foreignKeyIndexes = foreignKeyConstraints.keyValuesView().collect((Function & Serializable)keyValuePair -> IdxGenerator.getForeignKeyIndex((AssociationEnd)keyValuePair.getOne(), (MutableOrderedMap<DataTypeProperty, DataTypeProperty>)((MutableOrderedMap)keyValuePair.getTwo()), klass, tableName)).makeString("");
        return primaryKeyIndex + foreignKeyIndexes;
    }

    private static String getForeignKeyIndex(AssociationEnd associationEnd, MutableOrderedMap<DataTypeProperty, DataTypeProperty> dataTypeProperties, Klass klass, String tableName) {
        String constraintName = tableName + "_IDX_" + (String)DdlGenerator.TABLE_NAME_CONVERTER.convert((Object)associationEnd.getName());
        ImmutableList toProperties = klass.getDataTypeProperties().select(DataTypeProperty::isTo);
        ImmutableList allKeyProperties = dataTypeProperties.keysView().asLazy().concatenate((Iterable)toProperties).toImmutableList();
        if (IdxGenerator.isPrefixList((ImmutableList<DataTypeProperty>)allKeyProperties, IdxGenerator.getAllKeyProperties(klass))) {
            return "";
        }
        String foreignKeyColumnNames = allKeyProperties.collect(NamedElement::getName).collect(arg_0 -> DdlGenerator.COLUMN_NAME_CONVERTER.convert(arg_0)).makeString(", ");
        return "create index %s on %s(%s);\n\n".formatted(constraintName, tableName, foreignKeyColumnNames);
    }

    private static boolean isPrefixList(ImmutableList<DataTypeProperty> list1, ImmutableList<DataTypeProperty> list2) {
        if (list1.size() > list2.size()) {
            return false;
        }
        return list1.equals((Object)list2.subList(0, list1.size()));
    }

    @Nonnull
    private static String getPrimaryKeyColumnNames(Klass klass) {
        return IdxGenerator.getAllKeyProperties(klass).collect(NamedElement::getName).collect(arg_0 -> DdlGenerator.COLUMN_NAME_CONVERTER.convert(arg_0)).makeString(", ");
    }

    private static ImmutableList<DataTypeProperty> getAllKeyProperties(Klass klass) {
        ImmutableList toProperties = klass.getDataTypeProperties().select(DataTypeProperty::isTo);
        return klass.getKeyProperties().newWithAll((Iterable)toProperties);
    }
}

