/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.relational.schema;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import cool.klass.generator.relational.schema.RelationalSchemaGeneratorDataTypePropertyVisitor;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.visitor.DataTypePropertyVisitor;
import java.text.MessageFormat;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class DdlGenerator {
    public static final Converter<String, String> TABLE_NAME_CONVERTER = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE);
    public static final Converter<String, String> COLUMN_NAME_CONVERTER = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.LOWER_UNDERSCORE);

    private DdlGenerator() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static String getDdl(@Nonnull Klass klass) {
        Objects.requireNonNull(klass);
        String tableName = DdlGenerator.getTableName(klass);
        String propertiesSourceCode = DdlGenerator.getPropertiesSourceCode(klass);
        String format = "drop table if exists {0};\n\ncreate table {0}\n(\n{1}\n);\n\n";
        return MessageFormat.format(format, tableName, propertiesSourceCode);
    }

    @Nonnull
    public static String getTableName(@Nonnull Klass klass) {
        return (String)TABLE_NAME_CONVERTER.convert((Object)klass.getName());
    }

    @Nonnull
    private static String getPropertiesSourceCode(@Nonnull Klass klass) {
        return klass.getDataTypeProperties().reject(DataTypeProperty::isDerived).reject(DataTypeProperty::isTemporalRange).collect(DdlGenerator::getPropertySourceCode).makeString(",\n");
    }

    private static String getPropertySourceCode(DataTypeProperty dataTypeProperty) {
        String name = (String)COLUMN_NAME_CONVERTER.convert((Object)dataTypeProperty.getName());
        String dataType = DdlGenerator.getDataType(dataTypeProperty);
        String nullability = DdlGenerator.getNullability(dataTypeProperty);
        return "    %s %s%s".formatted(name, dataType, nullability);
    }

    private static String getDataType(DataTypeProperty dataTypeProperty) {
        RelationalSchemaGeneratorDataTypePropertyVisitor visitor = new RelationalSchemaGeneratorDataTypePropertyVisitor();
        dataTypeProperty.visit((DataTypePropertyVisitor)visitor);
        return visitor.getDataTypeSourceCode();
    }

    private static String getNullability(DataTypeProperty dataTypeProperty) {
        return dataTypeProperty.isTemporalInstant() || dataTypeProperty.isRequired() ? " not null" : "";
    }
}

