/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.relational.schema;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import cool.klass.generator.relational.schema.DdlGenerator;
import cool.klass.generator.relational.schema.FkGenerator;
import cool.klass.generator.relational.schema.IdxGenerator;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.Klass;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class RelationalSchemaGenerator {
    private static final Converter<String, String> CONVERTER = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE);
    private final DomainModel domainModel;

    public RelationalSchemaGenerator(DomainModel domainModel) {
        this.domainModel = Objects.requireNonNull(domainModel);
    }

    public void writeRelationalSchema(@Nonnull Path path) {
        for (Klass klass : this.domainModel.getClasses()) {
            Path fkOutputPath;
            Path idxOutputPath;
            String tableName = (String)CONVERTER.convert((Object)klass.getName());
            String packageName = klass.getPackageName();
            String relativePath = packageName.replaceAll("\\.", "/");
            Path parentPath = path.resolve(relativePath);
            RelationalSchemaGenerator.createDirectories(parentPath);
            Path ddlOutputPath = parentPath.resolve(tableName + ".ddl");
            if (!ddlOutputPath.toFile().exists()) {
                String sourceCode = DdlGenerator.getDdl(klass);
                this.printStringToFile(ddlOutputPath, sourceCode);
            }
            if (!(idxOutputPath = parentPath.resolve(tableName + ".idx")).toFile().exists()) {
                String sourceCode = IdxGenerator.getIdx(klass);
                this.printStringToFile(idxOutputPath, sourceCode);
            }
            if ((fkOutputPath = parentPath.resolve(tableName + ".fk")).toFile().exists()) continue;
            Optional<String> sourceCode = FkGenerator.getFk(klass);
            sourceCode.ifPresent(s -> this.printStringToFile(fkOutputPath, (String)s));
        }
    }

    private static void createDirectories(Path dir) {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void printStringToFile(@Nonnull Path path, String contents) {
        try (PrintStream printStream = new PrintStream(new FileOutputStream(path.toFile()));){
            printStream.print(contents);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

