/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.service;

import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.ReferenceProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Stacks;

public class DeepFetchWalker {
    private final MutableStack<AssociationEnd> associationEndStack = Stacks.mutable.empty();
    private final MutableStack<String> stringStack = Stacks.mutable.empty();
    private final MutableList<String> result = Lists.mutable.empty();
    private final Klass klass;

    public DeepFetchWalker(Klass klass) {
        this.klass = Objects.requireNonNull(klass);
    }

    public ImmutableList<String> getResult() {
        return this.result.toImmutable();
    }

    public void walk() {
        this.klass.getAssociationEnds().select(ReferenceProperty::isOwned).each(this::handleAssociationEnd);
    }

    public static ImmutableList<String> walk(Klass klass) {
        DeepFetchWalker deepFetchWalker = new DeepFetchWalker(klass);
        deepFetchWalker.walk();
        return deepFetchWalker.getResult();
    }

    private void handleAssociationEnd(@Nonnull AssociationEnd associationEnd) {
        this.associationEndStack.push((Object)associationEnd);
        this.stringStack.push((Object)associationEnd.getName());
        if (this.isLeaf(associationEnd)) {
            String string = this.stringStack.toList().asReversed().collect((Function & Serializable)each -> each + "()").makeString(".");
            String navigation = String.format("%sFinder.%s", this.klass.getName(), string);
            this.result.add((Object)navigation);
        }
        this.associationEndStack.pop();
        this.stringStack.pop();
    }

    private boolean isLeaf(@Nonnull AssociationEnd associationEnd) {
        return associationEnd.getType().getAssociationEnds().noneSatisfy(ReferenceProperty::isOwned);
    }
}

