/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.service;

import cool.klass.generator.service.OperationExpressionValueVisitor;
import cool.klass.generator.service.OperationOperatorVisitor;
import cool.klass.model.meta.domain.api.criteria.AllCriteria;
import cool.klass.model.meta.domain.api.criteria.AndCriteria;
import cool.klass.model.meta.domain.api.criteria.CriteriaVisitor;
import cool.klass.model.meta.domain.api.criteria.EdgePointCriteria;
import cool.klass.model.meta.domain.api.criteria.OperatorCriteria;
import cool.klass.model.meta.domain.api.criteria.OrCriteria;
import cool.klass.model.meta.domain.api.operator.Operator;
import cool.klass.model.meta.domain.api.operator.OperatorVisitor;
import cool.klass.model.meta.domain.api.value.ExpressionValue;
import cool.klass.model.meta.domain.api.value.ExpressionValueVisitor;
import cool.klass.model.meta.domain.api.value.MemberReferencePath;
import java.util.Objects;
import javax.annotation.Nonnull;

public class OperationCriteriaVisitor
implements CriteriaVisitor {
    private final String finderName;
    private final StringBuilder stringBuilder;

    public OperationCriteriaVisitor(@Nonnull String finderName, @Nonnull StringBuilder stringBuilder) {
        this.finderName = Objects.requireNonNull(finderName);
        this.stringBuilder = Objects.requireNonNull(stringBuilder);
    }

    public void visitAll(@Nonnull AllCriteria allCriteria) {
        this.stringBuilder.append(this.finderName).append(".all()");
    }

    public void visitAnd(@Nonnull AndCriteria andCriteria) {
        andCriteria.getLeft().visit((CriteriaVisitor)this);
        this.stringBuilder.append("\n                .and(");
        andCriteria.getRight().visit((CriteriaVisitor)this);
        this.stringBuilder.append(")");
    }

    public void visitOr(@Nonnull OrCriteria orCriteria) {
        orCriteria.getLeft().visit((CriteriaVisitor)this);
        this.stringBuilder.append("\n                .or(");
        orCriteria.getRight().visit((CriteriaVisitor)this);
        this.stringBuilder.append(")");
    }

    public void visitOperator(@Nonnull OperatorCriteria operatorCriteria) {
        ExpressionValue sourceValue = operatorCriteria.getSourceValue();
        Operator operator = operatorCriteria.getOperator();
        ExpressionValue targetValue = operatorCriteria.getTargetValue();
        sourceValue.visit((ExpressionValueVisitor)new OperationExpressionValueVisitor(this.finderName, this.stringBuilder));
        operator.visit((OperatorVisitor)new OperationOperatorVisitor(this.stringBuilder));
        targetValue.visit((ExpressionValueVisitor)new OperationExpressionValueVisitor(this.finderName, this.stringBuilder));
        this.stringBuilder.append(")");
    }

    public void visitEdgePoint(@Nonnull EdgePointCriteria edgePointCriteria) {
        MemberReferencePath memberExpressionValue = edgePointCriteria.getMemberExpressionValue();
        memberExpressionValue.visit((ExpressionValueVisitor)new OperationExpressionValueVisitor(this.finderName, this.stringBuilder));
        this.stringBuilder.append(".equalsEdgePoint()");
    }
}

