/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.service;

import cool.klass.generator.service.PrimitiveSetVisitor;
import cool.klass.generator.service.ReladomoPrimitiveVisitor;
import cool.klass.model.meta.domain.api.DataType;
import cool.klass.model.meta.domain.api.Enumeration;
import cool.klass.model.meta.domain.api.Multiplicity;
import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.PrimitiveType;
import cool.klass.model.meta.domain.api.Type;
import cool.klass.model.meta.domain.api.parameter.Parameter;
import cool.klass.model.meta.domain.api.value.ExpressionValueVisitor;
import cool.klass.model.meta.domain.api.value.ThisMemberReferencePath;
import cool.klass.model.meta.domain.api.value.TypeMemberReferencePath;
import cool.klass.model.meta.domain.api.value.VariableReference;
import cool.klass.model.meta.domain.api.value.literal.BooleanLiteralValue;
import cool.klass.model.meta.domain.api.value.literal.FloatingPointLiteralValue;
import cool.klass.model.meta.domain.api.value.literal.IntegerLiteralValue;
import cool.klass.model.meta.domain.api.value.literal.LiteralListValue;
import cool.klass.model.meta.domain.api.value.literal.LiteralValue;
import cool.klass.model.meta.domain.api.value.literal.NullLiteral;
import cool.klass.model.meta.domain.api.value.literal.StringLiteralValue;
import cool.klass.model.meta.domain.api.value.literal.UserLiteral;
import cool.klass.model.meta.domain.api.visitor.PrimitiveToJavaTypeVisitor;
import cool.klass.model.meta.domain.api.visitor.PrimitiveTypeVisitor;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.list.ImmutableList;

public class OperationExpressionValueVisitor
implements ExpressionValueVisitor {
    private final String finderName;
    private final StringBuilder stringBuilder;

    public OperationExpressionValueVisitor(@Nonnull String finderName, @Nonnull StringBuilder stringBuilder) {
        this.finderName = Objects.requireNonNull(finderName);
        this.stringBuilder = Objects.requireNonNull(stringBuilder);
    }

    public void visitTypeMember(@Nonnull TypeMemberReferencePath typeMemberExpressionValue) {
        ImmutableList associationEnds = typeMemberExpressionValue.getAssociationEnds();
        String associationEndsString = associationEnds.isEmpty() ? "" : "." + associationEnds.collect(NamedElement::getName).collect((Function & Serializable)string -> string + "()").makeString(".");
        String attribute = String.format("%sFinder%s.%s()", typeMemberExpressionValue.getKlass().getName(), associationEndsString, typeMemberExpressionValue.getProperty().getName());
        this.stringBuilder.append(attribute);
    }

    public void visitThisMember(@Nonnull ThisMemberReferencePath thisMemberExpressionValue) {
        ImmutableList associationEnds = thisMemberExpressionValue.getAssociationEnds();
        String associationEndsString = associationEnds.isEmpty() ? "" : "." + associationEnds.collect(NamedElement::getName).collect((Function & Serializable)string -> string + "()").makeString(".");
        String attribute = String.format("%s%s.%s()", this.finderName, associationEndsString, thisMemberExpressionValue.getProperty().getName());
        this.stringBuilder.append(attribute);
    }

    public void visitVariableReference(@Nonnull VariableReference variableReference) {
        Parameter parameter = variableReference.getParameter();
        DataType dataType = parameter.getType();
        Multiplicity multiplicity = parameter.getMultiplicity();
        if (dataType instanceof Enumeration) {
            this.stringBuilder.append(parameter.getName());
            return;
        }
        PrimitiveType primitiveType = (PrimitiveType)dataType;
        if (multiplicity.isToOne()) {
            primitiveType.visit((PrimitiveTypeVisitor)new ReladomoPrimitiveVisitor(this.stringBuilder, parameter.getName()));
            return;
        }
        primitiveType.visit((PrimitiveTypeVisitor)new PrimitiveSetVisitor(this.stringBuilder, parameter.getName()));
    }

    public void visitBooleanLiteral(@Nonnull BooleanLiteralValue booleanLiteralValue) {
        this.stringBuilder.append(booleanLiteralValue.getValue());
    }

    public void visitIntegerLiteral(@Nonnull IntegerLiteralValue integerLiteralValue) {
        this.stringBuilder.append(integerLiteralValue.getValue());
    }

    public void visitFloatingPointLiteral(@Nonnull FloatingPointLiteralValue floatingPointLiteralValue) {
        this.stringBuilder.append(floatingPointLiteralValue.getValue());
    }

    public void visitStringLiteral(@Nonnull StringLiteralValue stringLiteralValue) {
        this.stringBuilder.append('\"');
        this.stringBuilder.append(stringLiteralValue.getValue());
        this.stringBuilder.append('\"');
    }

    public void visitLiteralList(@Nonnull LiteralListValue literalListValue) {
        Type type = literalListValue.getType();
        this.stringBuilder.append(this.getType(type));
        this.stringBuilder.append("Sets.immutable.with(");
        this.stringBuilder.append(literalListValue.getLiteralValues().collect(this::getLiteralString).makeString());
        this.stringBuilder.append(")");
    }

    private String getType(Type type) {
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            return PrimitiveToJavaTypeVisitor.getJavaType((PrimitiveType)primitiveType);
        }
        throw new AssertionError();
    }

    public void visitUserLiteral(@Nonnull UserLiteral userLiteral) {
        this.stringBuilder.append("userPrincipalName");
    }

    public void visitNullLiteral(@Nonnull NullLiteral nullLiteral) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".visitNullLiteral() not implemented yet");
    }

    @Nonnull
    private String getLiteralString(@Nonnull LiteralValue literalValue) {
        StringBuilder stringBuilder = new StringBuilder();
        literalValue.visit((ExpressionValueVisitor)new OperationExpressionValueVisitor(this.finderName, stringBuilder));
        return stringBuilder.toString();
    }
}

