/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.service;

import cool.klass.model.meta.domain.api.visitor.PrimitiveTypeVisitor;
import java.util.Objects;

public class ReladomoPrimitiveVisitor
implements PrimitiveTypeVisitor {
    private final StringBuilder stringBuilder;
    private final String parameterName;

    public ReladomoPrimitiveVisitor(StringBuilder stringBuilder, String parameterName) {
        this.stringBuilder = Objects.requireNonNull(stringBuilder);
        this.parameterName = Objects.requireNonNull(parameterName);
    }

    public void visitString() {
        this.stringBuilder.append(this.parameterName);
    }

    public void visitInteger() {
        this.stringBuilder.append(this.parameterName);
    }

    public void visitLong() {
        this.stringBuilder.append(this.parameterName);
    }

    public void visitDouble() {
        this.stringBuilder.append(this.parameterName);
    }

    public void visitFloat() {
        this.stringBuilder.append(this.parameterName);
    }

    public void visitBoolean() {
        this.stringBuilder.append(this.parameterName);
    }

    public void visitInstant() {
        String sourceCode = String.format("Timestamp.from(%s.get().toZonedDateTime().toInstant())", this.parameterName);
        this.stringBuilder.append(sourceCode);
    }

    public void visitLocalDate() {
        String sourceCode = String.format("Timestamp.valueOf(%s.get().atStartOfDay())", this.parameterName);
        this.stringBuilder.append(sourceCode);
    }

    public void visitTemporalInstant() {
        String sourceCode = String.format("Timestamp.valueOf(LocalDateTime.ofInstant((Instant) %s, ZoneOffset.UTC))", this.parameterName);
        this.stringBuilder.append(sourceCode);
    }

    public void visitTemporalRange() {
        String sourceCode = String.format("Timestamp.valueOf(LocalDateTime.ofInstant((Instant) %s, ZoneOffset.UTC))", this.parameterName);
        this.stringBuilder.append(sourceCode);
    }
}

