/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.uml.nomnoml.plugin;

import cool.klass.generator.plugin.AbstractGenerateMojo;
import cool.klass.generator.uml.nomnoml.UmlNomnomlGenerator;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.source.DomainModelWithSourceCode;
import java.io.File;
import java.nio.file.Path;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-uml-diagram-nomnoml", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class GenerateUmlNomnomlMojo
extends AbstractGenerateMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-resources/uml-diagram-nomnoml")
    private File outputDirectory;
    @Parameter(property="applicationName", required=true)
    private String applicationName;
    @Parameter(property="rootPackageName", required=true)
    private String rootPackageName;

    public void execute() throws MojoExecutionException {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        DomainModelWithSourceCode domainModel = this.getDomainModel();
        Path outputPath = this.outputDirectory.toPath();
        UmlNomnomlGenerator generator = new UmlNomnomlGenerator((DomainModel)domainModel, this.rootPackageName, this.applicationName);
        generator.writeUmlDiagram(outputPath);
        Resource resource = new Resource();
        resource.setDirectory(this.outputDirectory.getAbsolutePath());
        this.mavenProject.addResource(resource);
    }
}

