/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.uml.nomnoml;

import cool.klass.model.meta.domain.api.Association;
import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.Enumeration;
import cool.klass.model.meta.domain.api.Interface;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.TopLevelElement;
import cool.klass.model.meta.domain.api.TopLevelElementVisitor;
import cool.klass.model.meta.domain.api.modifier.Modifier;
import cool.klass.model.meta.domain.api.projection.Projection;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.service.ServiceGroup;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.list.ImmutableList;

public class UmlNomnomlGenerator {
    @Nonnull
    private final DomainModel domainModel;
    @Nonnull
    private final String rootPackageName;
    @Nonnull
    private final String applicationName;

    public UmlNomnomlGenerator(@Nonnull DomainModel domainModel, @Nonnull String rootPackageName, @Nonnull String applicationName) {
        this.domainModel = Objects.requireNonNull(domainModel);
        this.rootPackageName = Objects.requireNonNull(rootPackageName);
        this.applicationName = Objects.requireNonNull(applicationName);
    }

    public void writeUmlDiagram(@Nonnull Path outputPath) {
        String topLevelElementsSourceCode = this.domainModel.getTopLevelElements().collect(this::getSourceCode).makeString("");
        String sourceCode = "// Auto-generated by cool.klass.generator.uml.nomnoml.UmlNomnomlGenerator\n\n" + topLevelElementsSourceCode;
        Path schemaOutputPath = this.getOutputPath(outputPath);
        this.printStringToFile(schemaOutputPath, sourceCode);
    }

    private String getSourceCode(TopLevelElement packageableElement) {
        TopLevelElementSourceCodeVisitor visitor = new TopLevelElementSourceCodeVisitor();
        packageableElement.visit((TopLevelElementVisitor)visitor);
        return visitor.getSourceCode();
    }

    @Nonnull
    private Path getOutputPath(@Nonnull Path outputPath) {
        String packageRelativePath = this.rootPackageName.replaceAll("\\.", "/");
        Path outputDirectory = outputPath.resolve(packageRelativePath).resolve("uml").resolve("nomnoml");
        outputDirectory.toFile().mkdirs();
        String fileName = this.applicationName + ".noml";
        return outputDirectory.resolve(fileName);
    }

    private void printStringToFile(@Nonnull Path path, String contents) {
        try (PrintStream printStream = new PrintStream(new FileOutputStream(path.toFile()));){
            printStream.print(contents);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class TopLevelElementSourceCodeVisitor
    implements TopLevelElementVisitor {
        private String sourceCode;

        private TopLevelElementSourceCodeVisitor() {
        }

        private String getSourceCode() {
            return this.sourceCode;
        }

        public void visitEnumeration(Enumeration enumeration) {
            String enumerationLiteralsSourceCode = enumeration.getEnumerationLiterals().collect(NamedElement::getName).collect((Function & Serializable)each -> "     " + each).makeString(";\n");
            this.sourceCode = "[ < enumeration >\n" + enumeration.getName() + "\n|\n" + enumerationLiteralsSourceCode + "\n]\n\n";
        }

        public void visitInterface(Interface anInterface) {
            String classGeneralizationSourceCode = "";
            this.sourceCode = this.getClassifierSourceCode((Classifier)anInterface, classGeneralizationSourceCode);
        }

        public void visitKlass(Klass klass) {
            String classGeneralizationSourceCode = this.getClassGeneralizationSourceCode(klass);
            this.sourceCode = this.getClassifierSourceCode((Classifier)klass, classGeneralizationSourceCode);
        }

        private String getClassifierSourceCode(Classifier classifier, String classGeneralizationSourceCode) {
            String interfaceGeneralizationsSourceCode = this.getInterfaceGeneralizationsSourceCode(classifier);
            String propertiesSourceCode = this.getClassifierPropertiesSourceCode(classifier);
            return "[ " + classifier.getName() + " |\n" + propertiesSourceCode + "\n]\n" + interfaceGeneralizationsSourceCode + classGeneralizationSourceCode + "\n";
        }

        private String getClassGeneralizationSourceCode(Klass klass) {
            return klass.getSuperClass().map(superClass -> this.getGeneralizationSourceCode((Klass)superClass, klass)).orElse("");
        }

        private String getInterfaceGeneralizationsSourceCode(Classifier classifier) {
            return classifier.getInterfaces().collectWith(this::getImplementationSourceCode, (Object)classifier).makeString();
        }

        private String getClassifierPropertiesSourceCode(Classifier classifier) {
            return classifier.getDataTypeProperties().reject(DataTypeProperty::isPrivate).reject(DataTypeProperty::isTemporalRange).collect(this::getPropertySourceCode).makeString(";\n");
        }

        private String getGeneralizationSourceCode(Klass superClass, Klass klass) {
            return String.format("[%s] -:> [%s]\n", klass.getName(), superClass.getName());
        }

        private String getImplementationSourceCode(Interface anInterface, Classifier classifier) {
            return String.format("[%s] --:> [%s]\n", classifier.getName(), anInterface.getName());
        }

        public void visitAssociation(Association association) {
            AssociationEnd sourceAssociationEnd = association.getSourceAssociationEnd();
            AssociationEnd targetAssociationEnd = association.getTargetAssociationEnd();
            String sourceClassName = sourceAssociationEnd.getOwningClassifier().getName();
            String targetClassName = targetAssociationEnd.getOwningClassifier().getName();
            String sourceName = sourceAssociationEnd.getName();
            String targetName = targetAssociationEnd.getName();
            String sourceMultiplicity = sourceAssociationEnd.getMultiplicity().getPrettyName();
            String targetMultiplicity = targetAssociationEnd.getMultiplicity().getPrettyName();
            String arrow = this.getArrow(sourceAssociationEnd, targetAssociationEnd);
            this.sourceCode = String.format("// %s%n[%s] %s %s %s %s %s [%s]%n%n", association.getName(), targetClassName, sourceName, sourceMultiplicity, arrow, targetName, targetMultiplicity, sourceClassName);
        }

        private String getArrow(AssociationEnd sourceAssociationEnd, AssociationEnd targetAssociationEnd) {
            if (targetAssociationEnd.isOwned()) {
                return "+->";
            }
            if (sourceAssociationEnd.isOwned()) {
                return "-+";
            }
            return "->";
        }

        public void visitProjection(Projection projection) {
            this.sourceCode = this.getPlaceholderComment((TopLevelElement)projection);
        }

        public void visitServiceGroup(ServiceGroup serviceGroup) {
            this.sourceCode = this.getPlaceholderComment((TopLevelElement)serviceGroup);
        }

        private String getPlaceholderComment(TopLevelElement topLevelElement) {
            return String.format("// %s %s%n", topLevelElement.getClass().getSimpleName(), topLevelElement.getName());
        }

        private String getPropertySourceCode(DataTypeProperty dataTypeProperty) {
            String isOptionalString = dataTypeProperty.isOptional() && !dataTypeProperty.isTemporal() ? "?" : "";
            ImmutableList relevantModifiers = dataTypeProperty.getModifiers().reject(Modifier::isAudit).reject(Modifier::isFrom).reject(Modifier::isTo).reject(Modifier::isSystem).reject(Modifier::isValid);
            String propertyModifiersString = relevantModifiers.isEmpty() ? "" : relevantModifiers.collect(Modifier::getKeyword).makeString(" // ", " ", "");
            return String.format("%s: %s%s%s", dataTypeProperty.getName(), dataTypeProperty.getType(), isOptionalString, propertyModifiersString);
        }
    }
}

