/*
 * Decompiled with CFR 0.152.
 */
package klass.model.meta.domain.service.resource;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonView;
import com.gs.fw.finder.Navigation;
import com.gs.fw.finder.Operation;
import com.gs.fw.finder.OrderBy;
import cool.klass.data.store.DataStore;
import cool.klass.model.meta.domain.api.DomainModel;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import klass.model.meta.domain.Association;
import klass.model.meta.domain.AssociationFinder;
import klass.model.meta.domain.AssociationList;
import klass.model.meta.domain.json.view.AssociationProjection_JsonView;
import org.eclipse.collections.impl.utility.Iterate;

@Path(value="/")
public class AssociationResource {
    @Nonnull
    private final DomainModel domainModel;
    @Nonnull
    private final DataStore dataStore;
    @Nonnull
    private final Clock clock;

    public AssociationResource(@Nonnull DomainModel domainModel, @Nonnull DataStore dataStore, @Nonnull Clock clock) {
        this.domainModel = Objects.requireNonNull(domainModel);
        this.dataStore = Objects.requireNonNull(dataStore);
        this.clock = Objects.requireNonNull(clock);
    }

    @Timed
    @ExceptionMetered
    @GET
    @Path(value="/meta/association/{name}")
    @Produces(value={"application/json"})
    @JsonView(value={AssociationProjection_JsonView.class})
    public Association method0(@PathParam(value="name") String name) {
        com.gs.fw.common.mithra.finder.Operation queryOperation = AssociationFinder.name().eq(name);
        AssociationList result = AssociationFinder.findMany((Operation)queryOperation);
        result.deepFetch((Navigation)AssociationFinder.packageableElementSuperClass());
        result.deepFetch((Navigation)AssociationFinder.associationEnds());
        result.deepFetch((Navigation)AssociationFinder.criteria());
        if (result.isEmpty()) {
            throw new ClientErrorException("Url valid, data not found.", Response.Status.GONE);
        }
        return (Association)Iterate.getOnly((Iterable)result);
    }

    @Timed
    @ExceptionMetered
    @GET
    @Path(value="/meta/association")
    @Produces(value={"application/json"})
    @JsonView(value={AssociationProjection_JsonView.class})
    public List<Association> method1() {
        com.gs.fw.common.mithra.finder.Operation queryOperation = AssociationFinder.all();
        AssociationList result = AssociationFinder.findMany((Operation)queryOperation);
        result.deepFetch((Navigation)AssociationFinder.packageableElementSuperClass());
        result.deepFetch((Navigation)AssociationFinder.associationEnds());
        result.deepFetch((Navigation)AssociationFinder.criteria());
        result.setOrderBy((OrderBy)AssociationFinder.packageableElementSuperClass().ordinal().ascendingOrderBy());
        return result;
    }
}

